#include "Note.h"
#include <string.h>

char *Tuning::names[12] = {
  "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#"
  };

void Tuning::Name(float freq, int &octave, char *note)
{
  double a = log(freq/eFreq)/log(2);
  octave = int(a);
  int step = int(12*a) % 12;
  int dec = int(10.0*(12.0*a-floor(12.0*a)));
  if (step < 0) step += 12;
  strcpy(note, names[step]);
  strcat(note, ". ");
  note[strlen(note)-1] = dec+'0';
}
