#ifndef _AUDIO_H
#define _AUDIO_H

#include <sys/types.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

typedef unsigned char byte;

class Audio
{
public:
  Audio(int SampleRate, int Vol);
  ~Audio();

  // reads time worth of samples into buf
  // ignores silences
  int Read(int time, double *out_buf);

  int GetSamples(int size, unsigned char *out_buf) {
    return read(audio, out_buf, size);
  }

  void Flush() { ioctl(audio, SNDCTL_DSP_SYNC, 0); }

private:

  int InitMixer(int vol);
  int InitAudio();

  int buf_size, SampleRate;
  byte *inp_buffer;
  int audio;
};

#endif
