#include "myfft.h"
#include <math.h>
#include <stdlib.h>
#include <iostream.h>

inline float Abs(float x) { return x > 0 ? x : -x; }

float MyFFT::GetFundamental()
{
  int i, noise = 0;
  int n = audio.GetSamples(size, buf);
  if (n == 0) return 0;
  for (i = 0; i < n; ++i)
    if (Abs(input(i) = 128.0-float(buf[i])) >= 10) noise = 1;
  if (!noise) return 0;
  fft.input(input);
  fft.real_half(xf_re);
  fft.imag_half(xf_im);
  float delta = float(sample)/n;
  n /= 2;

  float maxFreq, maxNorm = -1;
  for (i = 0; i < n; ++i) {
    double norm = xf_re(i)*xf_re(i)+xf_im(i)*xf_im(i);
    if (norm > maxNorm) {
      maxNorm = norm;
      maxFreq = i * delta;
    }
  }
  return maxFreq;
}
