#ifndef _FFT_H
#define _FFT_H

#include "gus.h"
#include "fft.h"

class MyFFT
{
public:
  MyFFT(int Sample, int Size, int Vol) : audio(Sample, Vol), fft(Size)
    , input(0, Size-1), xf_re(0, Size/2-1), xf_im(0, Size/2-1) {
    sample = Sample; size = Size; vol = Vol;
    buf = new (unsigned char)[size];
  }
  ~MyFFT() { delete buf; }

  float GetFundamental();	// reads audio and returns fundamental

  void Flush() { audio.Flush(); }

private:
  FFT fft;
  Vector input, xf_re, xf_im;
  unsigned char *buf;
  int sample, size, vol;
  Audio audio;
};

#endif
