/*
  snmp trap routine taken from cmu-snmp ----

*/

#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <arpa/inet.h>
#include <malloc.h>
#include <errno.h>

#include <snmp/snmp.h>
#include <snmp/asn1.h>
#include <snmp/snmp_impl.h>
#include <snmp/snmp_api.h>
#include <snmp/snmp_client.h>

int send_trap (char*, char*, char*, char*, char*, char* );
int snmp_dump_packet = 0;
#define NUM_NETWORKS 16
oid objid_enterprise[] = {1, 3, 6, 1, 4, 1, 3, 1, 1};
oid objid_sysdescr[] = {1, 3, 6, 1, 2, 1, 1, 1, 0};
#ifndef IFF_LOOPBACK
#define IFF_LOOPBACK 0
#endif
#define LOOPBACK    0x7f000001

u_long get_myaddr()
{
    int sd;
    struct ifconf ifc;
    struct ifreq conf[NUM_NETWORKS], *ifrp, ifreq;
    struct sockaddr_in *in_addr;
    int count;
    int interfaces;		/* number of interfaces returned by ioctl */

    if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	return 0;
    ifc.ifc_len = sizeof(conf);
    ifc.ifc_buf = (caddr_t)conf;
    if (ioctl(sd, SIOCGIFCONF, (char *)&ifc) < 0){
	close(sd);
	return 0;
    }
    ifrp = ifc.ifc_req;
    interfaces = ifc.ifc_len / sizeof(struct ifreq);
    for(count = 0; count < interfaces; count++, ifrp++){
	ifreq = *ifrp;
	if (ioctl(sd, SIOCGIFFLAGS, (char *)&ifreq) < 0)
	    continue;
	in_addr = (struct sockaddr_in *)&ifrp->ifr_addr;
	if ((ifreq.ifr_flags & IFF_UP)
	    && (ifreq.ifr_flags & IFF_RUNNING)
	    && !(ifreq.ifr_flags & IFF_LOOPBACK)
	    && in_addr->sin_addr.s_addr != LOOPBACK){
		close(sd);
		return in_addr->sin_addr.s_addr;
	    }
    }
    close(sd);
    return 0;
}
long uptime()
{

    FILE *in = fopen ("/proc/uptime", "r");
    long uptim = 0, a, b;
    if (in)
      {
	  if (2 == fscanf (in, "%ld.%ld", &a, &b))
	    uptim = a * 100 + b;
	  fclose (in);
      }
    return uptim;
}

u_long parse_address(address)
    char *address;
{
    u_long addr;
    struct sockaddr_in saddr;
    struct hostent *hp;

    if ((addr = inet_addr(address)) != -1)
	return addr;
    hp = gethostbyname(address);
    if (hp == NULL){
	fprintf(stderr, "unknown host: %s\n", address);
	return 0;
    } else {
	bcopy((char *)hp->h_addr, (char *)&saddr.sin_addr, hp->h_length);
	return saddr.sin_addr.s_addr;
    }

}
//-------------------------------------------------------------
int send_trap (host, comm, type, sp_type, trap_string, from_host)
char   *host, *comm, *type, *sp_type, *trap_string, *from_host;
{
    struct snmp_session session, *ss;
    struct snmp_pdu *pdu;
    struct variable_list *vars;

    char *gateway = host;
    char *community = comm;
    char *trap = type;
    char *specific = sp_type;
    char *description = trap_string;
    char *agent = from_host;

/*
printf ("\n%s\n%s\n%s\n%s\n%s\n%s", host, comm, type, sp_type, trap_string, from_host);
return 0;
*/
    bzero((char *)&session, sizeof(struct snmp_session));
    session.peername = gateway;
    session.community = (u_char *)community;
    session.community_len = strlen((char *)community);
    session.retries = SNMP_DEFAULT_RETRIES;
    session.timeout = SNMP_DEFAULT_TIMEOUT;
    session.authenticator = NULL;
    session.callback = 0;
    session.callback_magic = NULL;
    session.remote_port = SNMP_TRAP_PORT;
    ss = snmp_open(&session);
    if (ss == NULL){
	printf("Couldn't open snmp\n");
	return -1;
    }

    pdu = snmp_pdu_create(TRP_REQ_MSG);
    pdu->enterprise = (oid *)calloc(1, sizeof(objid_enterprise));
    bcopy((char *)objid_enterprise, (char *)pdu->enterprise, sizeof(objid_enterprise));
    pdu->enterprise_length = sizeof(objid_enterprise) / sizeof(oid);
    if (agent != NULL)
	pdu->agent_addr.sin_addr.s_addr = parse_address(agent);
    else
	pdu->agent_addr.sin_addr.s_addr = get_myaddr();
    pdu->trap_type = atoi(trap);
    pdu->specific_type = atoi(specific);
    pdu->time = uptime();

    pdu->variables = vars = (struct variable_list *)calloc(1, sizeof(struct variable_list));
    vars->next_variable = NULL;
    vars->name = (oid *)calloc(1, sizeof(objid_sysdescr));
    bcopy((char *)objid_sysdescr, (char *)vars->name, sizeof(objid_sysdescr));
    vars->name_length = sizeof(objid_sysdescr) / sizeof(oid);
    vars->type = ASN_OCTET_STR;
    vars->val.string = (u_char *)calloc(1, strlen(description) + 1);
    strcpy((char *)vars->val.string, description);
    vars->val_len = strlen(description);

    if (snmp_send(ss, pdu)== 0){
	printf("error\n");
    }
    snmp_free_pdu(pdu);
    snmp_close(ss);

    return 0;
}

/* end */











