/*
  xrus - keyboard switcher/indicator
  Copyright (c) 1996 Alexander V. Lukyanov
  This is free software with no warranty.
  See COPYING for details.
*/
/*__________________________________________________________________________
**
** File: props.c
**__________________________________________________________________________
*/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#ifdef HAVE_MOTIF
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/DialogS.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Scale.h>
#include <Xm/Frame.h>
#include <Xm/TextF.h>
#include <Xm/LabelG.h>
#include <Xm/MessageB.h>
#endif

#include "keycomb.h"
#include "xrus.h"

#include "xalloca.h"

#ifdef HAVE_MOTIF
struct
{
   Widget   shell,form,ok_button,apply_button,cancel_button;
   Widget   allow_locker,autolock_delay,use_bell;
   Widget   frame1,frame2,form1;
   Widget   form2,form4;
   Widget   locker,switch_keys,locker_def,switch_keys_def;
   Widget   to_lat_keys,to_rus_keys;
   Widget   locker_test,save_button;
}
   props;

static
void  PropsSet()
{
   XtVaSetValues(props.allow_locker,XmNset,!!AppData.autolock,NULL);
   XtVaSetValues(props.autolock_delay,XmNvalue,AppData.timeout,NULL);
   XtVaSetValues(props.use_bell,XmNset,!!AppData.useBell,NULL);
   XtVaSetValues(props.locker,XmNvalue,AppData.locker,NULL);
   XtVaSetValues(props.switch_keys,XmNvalue,AppData.switchKeys,NULL);
   XtVaSetValues(props.to_lat_keys,XmNvalue,AppData.toLatKeys,NULL);
   XtVaSetValues(props.to_rus_keys,XmNvalue,AppData.toRusKeys,NULL);
}

static
void  ErrorDismiss_CB(Widget w,XtPointer closure,XtPointer call_data)
{
   XtDestroyWidget(w);
}

static
int  PropsApply()
{
   char  *value;
   char  old_switchKeys[256];
   char  message[1024];
   char  large_message[3*1024];
   Widget error;

   large_message[0]=0;

   strcpy(old_switchKeys,AppData.switchKeys);
   XtVaGetValues(props.switch_keys,XmNvalue,&value,NULL);
   strcpy(AppData.switchKeys,value);
   ParseKeyCombination(AppData.switchKeys,&SwitchKeys,message);
   if(*message)
   {
      strcat(large_message,message);

      strcpy(AppData.switchKeys,old_switchKeys);
      ParseKeyCombination(AppData.switchKeys,&SwitchKeys,message);
   }

   strcpy(old_switchKeys,AppData.toLatKeys);
   XtVaGetValues(props.to_lat_keys,XmNvalue,&value,NULL);
   strcpy(AppData.toLatKeys,value);
   ParseKeyCombination(AppData.toLatKeys,&ToLatKeys,message);
   if(*message)
   {
      strcat(large_message,message);

      strcpy(AppData.toLatKeys,old_switchKeys);
      ParseKeyCombination(AppData.toLatKeys,&ToLatKeys,message);
   }

   strcpy(old_switchKeys,AppData.toRusKeys);
   XtVaGetValues(props.to_rus_keys,XmNvalue,&value,NULL);
   strcpy(AppData.toRusKeys,value);
   ParseKeyCombination(AppData.toRusKeys,&ToRusKeys,message);
   if(*message)
   {
      strcat(large_message,message);

      strcpy(AppData.toRusKeys,old_switchKeys);
      ParseKeyCombination(AppData.toRusKeys,&ToRusKeys,message);
   }

   if(large_message[0])
   {
      Arg   arg[3];
      XmString msg=XmStringCreateLocalized(large_message);
      XmString title=XmStringCreateLocalized("Parse error");

      if(message[strlen(message)-1]=='\n')
         message[strlen(message)-1]=0;

      XtSetArg(arg[0],XmNmessageString,msg);
      XtSetArg(arg[1],XmNdialogStyle,XmDIALOG_APPLICATION_MODAL);
      XtSetArg(arg[2],XmNdialogTitle,title);
      error=XmCreateErrorDialog(props.shell,"error",arg,3);
      XtUnmanageChild(XtNameToWidget(error,"Cancel"));
      XtUnmanageChild(XtNameToWidget(error,"Help"));
      XtAddCallback(error,XmNunmapCallback,ErrorDismiss_CB,0);

      XmStringFree(msg);
      XmStringFree(title);
      XtManageChild(error);

      return 0;
   }

   XtVaGetValues(props.locker,XmNvalue,&value,NULL);
   strcpy(AppData.locker,value);

   XtVaGetValues(props.allow_locker,XmNset,&AppData.autolock,NULL);
   XtVaGetValues(props.autolock_delay,XmNvalue,&AppData.timeout,NULL);
   XtVaGetValues(props.use_bell,XmNset,&AppData.useBell,NULL);
   SetAlarm();
   return 1;
}

static
void  PropsPopdown()
{
   XtPopdown(props.shell);
   XtUnmanageChild(props.form);
}

void  PropsSave()
{
   FILE  *f;
   char  *HOME=getenv("HOME");
   char  *filename;

   if(!HOME)
      return;

   filename=alloca(strlen(HOME)+10);
   sprintf(filename,"%s/.xrus",HOME);

   f=fopen(filename,"w");
   if(!f)
   {
      perror(filename);
      return;
   }

   fprintf(f,"! This file was created automatically by Xrus\n"
      "Xrus*locker:\t\t%s\n"
      "Xrus*timeout:\t\t%d\n"
      "Xrus*autolock:\t\t%s\n"
      "Xrus*useBell:\t\t%s\n"
      "Xrus*switchKeys:\t%s\n"
      "Xrus*toLatKeys:\t\t%s\n"
      "Xrus*toRusKeys:\t\t%s\n",

      AppData.locker,
      AppData.timeout,
      AppData.autolock?"true":"false",
      AppData.useBell ?"true":"false",
      AppData.switchKeys,
      AppData.toLatKeys,
      AppData.toRusKeys
      );

   fclose(f);
}

static
void  Button_CB(Widget w,XtPointer user_data,XtPointer cb_data)
{
   switch((int)user_data)
   {
   case(0): /* Ok */
      if(!PropsApply())
         return;
      PropsPopdown();
      break;
   case(1): /* Apply */
      if(!PropsApply())
         return;
      break;
   case(2): /* Cancel */
      PropsPopdown();
      break;
   case(3): /* Save */
      if(!PropsApply())
         return;
      PropsSave();
      PropsPopdown();
      break;
   }
}

static
void  LockerTest_CB(Widget w,XtPointer user_data,XtPointer cb_data)
{
   char  *value;
   char  old_locker[256];

   strcpy(old_locker,AppData.locker);
   XtVaGetValues(props.locker,XmNvalue,&value,NULL);
   strcpy(AppData.locker,value);

   LockScreen();

   strcpy(AppData.locker,old_locker);
}

static
void  Default_CB(Widget w,XtPointer closure,XtPointer cd_data)
{
   switch((int)closure)
   {
   case(0):
      /* set locker defaults */
      XtVaSetValues(props.locker,XmNvalue,DefaultLocker,NULL);
      XtVaSetValues(props.allow_locker,XmNset,0,NULL);
      XtVaSetValues(props.autolock_delay,XmNvalue,30,NULL);
      break;
   case(1):
      /* set switch keys default */
      XtVaSetValues(props.use_bell,XmNset,0,NULL);
      XtVaSetValues(props.switch_keys,XmNvalue,DefaultSwitchKeys,NULL);
      XtVaSetValues(props.to_lat_keys,XmNvalue,DefaultToLatKeys,NULL);
      XtVaSetValues(props.to_rus_keys,XmNvalue,DefaultToRusKeys,NULL);
      break;
   }
}

static
void  PropsInit()
{
   static inited=0;
   int   count;
   Arg   args[10];

   if(inited)
      return;

/* Create Properties sheet */

   StartArgs();
   AddArg(XmNmappedWhenManaged,False);
   props.shell=XmCreateDialogShell(top_level,"props",args,count);

   props.form=XtVaCreateWidget("form",xmFormWidgetClass,props.shell,
      XmNautoUnmanage,False,
      NULL);

   props.frame1=XtVaCreateManagedWidget("frame1",xmFrameWidgetClass,props.form,NULL);
   props.form1=XtVaCreateManagedWidget("form1",xmFormWidgetClass,props.frame1,NULL);

   props.locker_def=XtVaCreateManagedWidget("locker_def",xmPushButtonWidgetClass,props.form1,NULL);
   XtAddCallback(props.locker_def,XmNactivateCallback,Default_CB,(XtPointer)0);

   props.locker_test=XtVaCreateManagedWidget("locker_test",xmPushButtonWidgetClass,props.form1,NULL);
   XtAddCallback(props.locker_test,XmNactivateCallback,LockerTest_CB,(XtPointer)0);

   props.locker=XtVaCreateManagedWidget("locker",xmTextFieldWidgetClass,props.form1,NULL);
   XtVaCreateManagedWidget("locker_label",xmLabelGadgetClass,props.form1,NULL);

   props.allow_locker=XtVaCreateManagedWidget("allow_locker",xmToggleButtonWidgetClass,props.form1,NULL);
   props.autolock_delay=XtVaCreateManagedWidget("autolock_delay",xmScaleWidgetClass,props.form1,NULL);

   props.frame2=XtVaCreateManagedWidget("frame2",xmFrameWidgetClass,props.form,NULL);
   props.form2=XtVaCreateManagedWidget("form2",xmFormWidgetClass,props.frame2,NULL);

   props.use_bell=XtVaCreateManagedWidget("use_bell",xmToggleButtonWidgetClass,props.form2,NULL);
   XtVaCreateManagedWidget("switch_keys_label",xmLabelGadgetClass,props.form2,NULL);
   props.switch_keys=XtVaCreateManagedWidget("switch_keys",xmTextFieldWidgetClass,props.form2,NULL);
   XtVaCreateManagedWidget("to_lat_keys_label",xmLabelGadgetClass,props.form2,NULL);
   props.to_lat_keys=XtVaCreateManagedWidget("to_lat_keys",xmTextFieldWidgetClass,props.form2,NULL);
   XtVaCreateManagedWidget("to_rus_keys_label",xmLabelGadgetClass,props.form2,NULL);
   props.to_rus_keys=XtVaCreateManagedWidget("to_rus_keys",xmTextFieldWidgetClass,props.form2,NULL);

   props.switch_keys_def=XtVaCreateManagedWidget("switch_keys_def",xmPushButtonWidgetClass,props.form2,NULL);
   XtAddCallback(props.switch_keys_def,XmNactivateCallback,Default_CB,(XtPointer)1);

   props.form4=XtVaCreateManagedWidget("form4",xmFormWidgetClass,props.form,NULL);

   props.ok_button=XtVaCreateManagedWidget("ok",xmPushButtonWidgetClass,props.form4,NULL);
   XtVaSetValues(props.form,
      XmNdefaultButton,props.ok_button,
      NULL);
   XtVaSetValues(props.form4,
      XmNdefaultButton,props.ok_button,
      NULL);

   props.cancel_button=XtVaCreateManagedWidget("cancel",xmPushButtonWidgetClass,props.form4,NULL);
   props.apply_button=XtVaCreateManagedWidget("apply",xmPushButtonWidgetClass,props.form4,NULL);
   props.save_button=XtVaCreateManagedWidget("save",xmPushButtonWidgetClass,props.form4,NULL);

   XtVaSetValues(props.form,
      XmNcancelButton,props.cancel_button,
      NULL);

   XtAddCallback(props.ok_button,XmNactivateCallback,Button_CB,(XtPointer)0);
   XtAddCallback(props.apply_button,XmNactivateCallback,Button_CB,(XtPointer)1);
   XtAddCallback(props.cancel_button,XmNactivateCallback,Button_CB,(XtPointer)2);
   XtAddCallback(props.save_button,XmNactivateCallback,Button_CB,(XtPointer)3);

   inited=1;
}
#endif /* HAVE_MOTIF */

void  PropsPopup()
{
#ifdef HAVE_MOTIF
   int   count;
   Arg   args[10];
   Dimension   width,height;
   static limit_set=0;

   PropsInit();
   if(!XtIsManaged(props.form))
      PropsSet();
   XtManageChild(props.form);

   if(!limit_set)
   {
      StartArgs();
      AddArg(XmNwidth,&width);
      AddArg(XmNheight,&height);
      XtGetValues(props.shell,args,count);
      StartArgs();
      AddArg(XmNminWidth,width);
      AddArg(XmNminHeight,height);
      AddArg(XmNmaxHeight,height);
      XtSetValues(props.shell,args,count);

      limit_set=1;
   }

   XtPopup(props.shell,XtGrabNone);
#else
   XBell(disp,0);
#endif
}
