#include "gus.h"

#include <iostream.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>
#include <vga.h>

const char *mixer_device = "/dev/mixer";
const char *audio_device = "/dev/dsp";

const int SilenceCutOff = 10;

inline int Abs(int a) { return a < 0 ? -a : a; }

inline int Silent(int a) { return Abs(a-128) < SilenceCutOff; }

Audio::Audio(int _SampleRate, int Vol)
{
  SampleRate = _SampleRate;
  // the mixer settings are maintained
  int mixer = InitMixer(Vol);
  close(mixer);
  audio = InitAudio();
}

Audio::~Audio()
{
  close(audio);
}

int Audio::InitMixer(int vol)
{
  int mixer = open(mixer_device, O_RDONLY, 0);
  ioctl(mixer, SOUND_MIXER_WRITE_MIC, &vol);
  return mixer;
}  

int Audio::InitAudio()
{
  int audio = open(audio_device, O_RDONLY, 0);
  if (audio == -1) {
    perror(audio_device);
    exit(1);
  }

  ioctl(audio, SNDCTL_DSP_GETBLKSIZE, &buf_size);

  ioctl(audio, SNDCTL_DSP_SYNC, NULL);
  int sample_size = 8;
  ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &sample_size);

  int stereo = 0;
  ioctl(audio, SNDCTL_DSP_STEREO, &stereo);

  int speed = SampleRate;
  ioctl(audio, SNDCTL_DSP_SPEED, &speed);
  return audio;
}

int Audio::Read(int time, double *out_buf)
{
  if (time < 1) return 0;
  int len = time*SampleRate;
  inp_buffer = new char[buf_size];
  do {
    int n = read(audio, inp_buffer, buf_size);
    for (int i = 0; i < n && Silent(inp_buffer[i]); ++i);
    if (i == n) continue;
    
    cout << "Sampling" << endl;
    len -= n-i;
    for (; i < n; *out_buf++ = 128.0-double(inp_buffer[i++]));
    while (len > 0) {
      n = read(audio, inp_buffer, buf_size);
      for (i = 0; i < n && i < len;
	   *out_buf++ = 128.0-double(inp_buffer[i++]));
      len -= n;
    }
    break;
  }
  while (1);
  delete [] inp_buffer;
  return time*SampleRate;
}
