#include "tune.h"
#include "myfft.h"
#include "gus.h"
#include "Note.h"
#include <vga.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>

// float stringFreqs[] = { 82, 110, 147, 196, 247, 329 };

// float stringFreqs[] = { 87, 116, 155, 207, 261, 349 };

int Yes()
{
  char inp[80];
  cin.getline(inp, 80);
  return strcmp(inp, "n") != 0;
}

void TuneGuitar(int sample, int vol, int time, float eFreq)
{
  int power = 1;
  unsigned int size = sample*time/10;
  while (power < size) power <<= 1;
  if (power > 32767) {
    cerr << "buffer size too big, try smaller sample rate or less time\n";
    exit(1);
  }
  MyFFT fft(sample, power, vol);

  cout << "Use standard tuning, low E = " << eFreq << " (y/n): ";
  if (!Yes()) {
    float sum = 0;
    int times = 0;
    while (1) {
      cout << "Play note for low E:\n";
      float freq;
      fft.Flush();
      while ((freq = fft.GetFundamental()) == 0);
      cout << "found " << freq << " accept? ";
      if (Yes()) {
	sum += freq;
	++times;
	cout << "Sample again? ";
	if (!Yes()) break;
      }
    }
    eFreq = sum/times;
  }
  while (eFreq < 30 || eFreq > 120) {
    if (eFreq < 30) eFreq *= 2;
    if (eFreq > 120) eFreq /= 2;
  }
  cout << "Frequency of E is " << eFreq << endl;
  cout << "Play notes to get frequency\n\n";
  Tuning *tuning = new Tuning(eFreq);
  int count = 0;
  while (1) {
    float freq = fft.GetFundamental();
    if (freq == 0) continue;
    cout << Note(freq, tuning);
    if ((++count % 10) == 0) cout << endl;
    else cout << " ";
    cout.flush();
  }
  delete tuning;
}
