/*
	pingerd.h - pinger daemon header file
	Copyright (c) by Alexey Semenov
*/

#ifndef __PINGERD_H_
#define __PINGERD_H_ 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#define TRUE 1
#define FALSE 0

#define LOG_FILE_NAME "/var/log/pingerd.log"
#define FILE_HOT_ALARM "/var/log/pingerd.hot"
#define FILE_HOT_ALARM_TEMP "/var/log/pingerd.hot.tmp"
#define PING_PIPE "/tmp/ppingerd.tmp"
#define PING_CMD "/bin/ping -c2 -s16 "

#ifndef FILE_NODES 
#define FILE_NODES "/etc/pingerd.hosts"
#endif

void daemonize (void);
void get_time_string (char*);
int is_node_live (char*);
void ping_node(char*);


#endif /* __PINGERD_H_ */











