#ifndef _NOTE_H
#define _NOTE_H

#include <math.h>
#include <iostream.h>

// you give this the frequency of the low E of the guitar
// and then every note is named relative to that
class Tuning
{
public:
  Tuning(float freq) { eFreq = freq; }
  ~Tuning() {}

  // names a note. The octave is how many powers of 2 it is
  // above or below the base. We copy the name such a E# or C into note
  // so note must be at least 3 bytes
  void Name(float f, int &octave, char *note);

private:
  float eFreq;
  static char *names[12];
};

class Note
{
public:
  Note(float freq, Tuning *t) { f = freq; tuning = t; }
  ~Note() {}

  // goes up one step
  Note operator++() { f *= pow(2.0, 1.0/12.0); return *this; }
  Note operator--() { f *= pow(2.0, -1.0/12.0); return *this; }

  Note operator+=(int n) {
    while (n-- > 0)
      f *= pow(2.0, 1.0/12.0);
  }

  friend ostream& operator<<(ostream &, Note &);

  float Freq() { return f; }
  Tuning *GetTuning() { return tuning; }
  void SetTuning(Tuning *t) { tuning = t; }

private:
  float f;
  Tuning *tuning;
};

inline ostream &operator<<(ostream &os, Note &n)
{
  char name[20];
  int octave;
  n.tuning->Name(n.f, octave, name);
  return os << name;
}

#endif
