#include "tune.h"
#include <stdio.h>
#include <getopt.h>
#include <vga.h>
#include <stdlib.h>

main(int argc, char **argv)
{
  int opt, sample = 32768, time = 5, vol = 20, eFreq = 87;

  while ((opt = getopt(argc, argv, "e:s:t:v:h")) != EOF) {
    switch (opt) {
    case 's':
      sample = atoi(optarg); break;
    case 't':
      time = atoi(optarg); break;
    case 'v':
      vol = atoi(optarg); break;
    case 'e':
      eFreq = atoi(optarg); break;
    case 'h':
    case '?':
      printf("usage: %s [OPTION]\n", argv[0]);
      printf("\t-e frequency of E, default 87\n");
      printf("\t-s sample rate, default 32768\n");
      printf("\t-t time to sample in 10ths of a second, default 5\n");
      printf("\t-v mixer volume, default 20\n");
      printf("\t-h help\n");
      exit(1);
    }
  }

  TuneGuitar(sample, vol, time, eFreq);
}

