/*

  Reminder daemon
  Written by Alexey Semenov

*/

#include "remd.h"

void remind_user (char *user, char *dir)
{
	char buff[128], udir[65], uname[128],
	     mes_year[16], mes_date[32], c_mes_date[32], *ptr;
	int message_year, message_date, c_message_year, c_message_date;
	struct dirent **dirlist;
	int a, b;
	char *months[]={ "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec" };
	char *time_string, tstr[64];
	FILE *mail_pipe, *fl1;
 
	time_t timv = time (0);
	time_string=ctime (&timv);                                                                   
	time_string[strlen(time_string)-1]=0;
	strncpy (tstr,time_string, sizeof(tstr)-1);

	strtok (tstr, " \t\n\r");
	ptr = strtok ( NULL,  " \t\n\r");
	for (a=0; a<12; a++ ) {
		if (strncmp (ptr, months[a], 3)==0) {
			break;
		}
	}
	a++;

	ptr = strtok ( NULL,  " \t\n\r");
	b = atoi (ptr);

	memset (c_mes_date, 0, sizeof (c_mes_date));

	sprintf ( c_mes_date, "%.2d%.2d", a,b);
	ptr = strtok ( NULL,  " \t\n\r");
	strncat ( c_mes_date, ptr,2 ); ptr+=3; strncat ( c_mes_date, ptr,2 );
	c_message_date = atoi (c_mes_date);

	c_message_year = atoi (strtok(NULL,  " \t\n\r"));

	memset (buff, 0, sizeof(buff));
	memset (udir, 0, sizeof (udir));
	memset (uname, 0 ,sizeof (uname));
	memset (&dirlist,0, sizeof (dirlist));

	strncpy(udir,dir,50);
	strcat(udir,"/.reminder");

	if ((a = scandir(udir, &dirlist, 0, alphasort) ) <3 ) return;

	while(a--) {

		memset (mes_year, 0, sizeof (mes_year));
		memset (mes_date, 0, sizeof(mes_date));

		if (strstr (dirlist[a]->d_name, ".msg") == NULL ) {
			free (dirlist[a]);
			continue;
		}
		strncpy (buff, dirlist[a]->d_name, 30);
		strtok (buff,". \t\r\n");
		free (dirlist[a]);	
		strncpy (mes_year, buff, 4);
		ptr=buff; ptr+=5;

		strncpy (mes_date, ptr,2); ptr+=3;

		for ( b=0; b<3; b++) {
			strncat (mes_date, ptr,2);
			ptr+=3;
		}

		message_year = strtol (mes_year, NULL, 10);
		message_date = strtol (mes_date, NULL, 10);

		strncpy (uname, udir, 64);
		strcat (uname, "/");
		strncat (uname, dirlist[a]->d_name,60);

		if ( (message_year > 2100 ) || ( message_year == 0 ) ||
        	     (message_date > 12312359 ) || ( message_date == 0 ) ) {
			syslog (LOG_WARNING, "File %s has invalid name", uname);
			continue;
		}

#ifdef DEBUG
		
		printf(">%s<\n", uname);
		printf(">%d<=>%d<\n\n", message_year,message_date);
		printf(">%d<=>%d<\n\n", c_message_year,c_message_date);
#endif

		if (( c_message_year > message_year ) ||
		    (( c_message_year == message_year) && (c_message_date >= message_date))) {

			strcpy (buff, MAIL); strcat (buff, " -s REMINDER_daemon ");
			strcat (buff, user);

#ifdef DEBUG

			printf ("%s \n", buff);
#endif

			if (( mail_pipe = popen (buff, "w")) == NULL) {
				syslog (LOG_WARNING, "Popen error: %s", buff);
				break;
			}

			if ((fl1=fopen (uname, "r")) == NULL) {
				syslog (LOG_WARNING, "Fopen %s: %m", uname); 
				fprintf ( mail_pipe,"Can't open %s", uname);
				pclose (mail_pipe);
				continue;
			}

			fprintf ( mail_pipe,"Message %s:\n", uname);
			fprintf ( mail_pipe,"-----------------------------------------------------------------\n");
			while ((fgets(buff, sizeof(buff)-1, fl1))!=NULL) {
				fputs (buff, mail_pipe);
			}

			fclose (fl1);

			if ((pclose (mail_pipe) == -1 )) {
				syslog (LOG_WARNING, "Pclose error: %s", buff);
				break;
			}

			unlink (uname);
		}
	}
}

void daemonize (void)
{                                                                                                  
	switch (fork()) {
        case 0:
		chdir ("/");
		setsid ();
		break;
        case -1:
		printf ("Can't fork()");
		exit (1);
	default:
		exit (0);
        }
}     

void print_usage (void)
{
	printf ( "--------------------------------------------------------\n");
	printf ( "Reminder daemon program. Ver. %s\n",VERSION);
	printf ( "Was written by (c) Alexey Semenov, 1999-2001\n\n");
	printf ( "Email:  swajj@yahoo.com\n");
	printf ( "URL:    http://www.geocities.com/SiliconValley/Way/7914/\n");
	printf ( "--------------------------------------------------------\n");
	printf ( "Usage: remd      [ -d run as daemon | -c run from crond ]\n");
	printf ( "                 [-t sec check interval >0 (has effect with -d only) ]\n\n");
}
//--------------------------------------------------
void check_users (void) {

	FILE *fl1;
	char buff[17];
	struct passwd *pwd;

	openlog("remd", LOG_CONS | LOG_PID, LOG_WARNING);

	if ((fl1=fopen(USER_FILE_NAME,"r"))==NULL) {
		syslog (LOG_WARNING, "File %s: %m", USER_FILE_NAME);
		exit (-1);
	}

	while ((fgets(buff, 16, fl1))!=NULL) {
		if (strncmp(buff,"#",1)!=0) {
			strtok (buff," \t\n\r");
			if (((pwd = getpwnam (buff))==NULL) ||
			    ((pwd->pw_dir)==NULL ) ) {
				syslog (LOG_WARNING, "User %s nas no home directory", buff);
			} else {
				remind_user (buff,pwd->pw_dir);
			}
		}
	}
	fclose (fl1);
	closelog ();
}

int main (int argc, char **argv)
{ 
	char buff[64];
	int mode=2, check_tim;
	char ch;
	int a;

	if (argc < 2) {
		print_usage ();
		exit (0);
	}

	while ((ch=getopt( argc, argv, "dct:")) != EOF ) {
		switch (ch) {
		case 'd':
			if (mode!=2) {
				print_usage ();
				exit (0);
			} else {
				mode = 0;
				break;
			}
		case 'c':
			if (mode!=2) {
				print_usage ();
				exit (0);
			} else {
				mode = 1;
				break;
			}
		case 't':
			strncpy (buff, optarg, sizeof(buff)-1);
			break;
		default:
			print_usage ();
			exit(0);
		}
	}

	if (!(mode)) {
		check_tim = atoi (buff);
		if (check_tim == 0 )  {
			print_usage ();
			exit (0);
		}
	}

	if (mode) {
		check_users();
		exit (0);
	} else {
		chdir ("/");
		openlog("remd", LOG_CONS | LOG_PID, LOG_WARNING); 
		strncpy (buff, argv[0], sizeof(buff)-3);
		strcat (buff, " -c");

		daemonize();
		syslog (LOG_WARNING, "Fork OK, checking interval = %d sec",check_tim);

		while (1) {
			a = system (buff);
			if ( a != 0 ) {
				syslog (LOG_WARNING, "system() failed for %s", buff);
			}
			sleep (check_tim);
		}
	}
}

/* end */



















