/*
 * Copyright (C) Sergey P. Derevyago, 2000-2004.
 *
 * Permission to copy, use, modify, sell and distribute this software is granted
 * provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <list>

struct DList {  //  
       struct Data {
              int val;
              Data *prev, *next;

              Data(int v, Data* p=0, Data* n=0) : val(v), prev(p), next(n) {}

              //    
              static Data* free;
              static void allocate();
              void* operator new(size_t);
              void operator delete(void*, size_t);
       };

       Data *head, *tail;

       DList() { head=tail=0; }
       
       ~DList()
       {
        for (Data *ptr=head, *n; ptr; ptr=n) {  //   
            n=ptr->next;
            delete ptr;
        }
       }

       void push_back(int v)  //  
       {
        if (!head) head=tail=new Data(v);
        else tail=tail->next=new Data(v, tail);
       }
};

DList::Data* DList::Data::free;

void DList::Data::allocate()
{
 const int sz=100;  //    sz 
 free=reinterpret_cast<Data*>(new char[sz*sizeof(Data)]);

 //   
 for (int i=0; i<sz-1; i++)
     free[i].next=free+i+1;
 free[sz-1].next=0;
}

inline void* DList::Data::operator new(size_t)
{
 if (!free) allocate();

 Data* ptr=free;
 free=free->next;

 return ptr;
}

inline void DList::Data::operator delete(void* dl, size_t)
{  //      
 Data* ptr=static_cast<Data*>(dl);
 ptr->next=free;
 free=ptr;
}

long Count, Var;

void f1()
{
 DList lst;
 for (int i=0; i<1000; i++)
     lst.push_back(i);

 for (DList::Data* ptr=lst.head; ptr; ptr=ptr->next)
     Var+=ptr->val;
}

void f2()
{
 typedef std::list<int> list_type;

 list_type lst;
 for (int i=0; i<1000; i++)
     lst.push_back(i);

 for (list_type::const_iterator ci=lst.begin(), cend=lst.end(); ci!=cend; ++ci)
     Var+=*ci;
}

int main(int argc, char** argv)
{
 if (argc>1) Count=atol(argv[1]);

 clock_t c1, c2;
 {
  c1=clock();

  for (long i=0; i<Count; i++)
      for (long j=0; j<1000; j++)
          f1();

  c2=clock();
  printf("f1(): %ld ths calls per %.1f sec\n", Count, double(c2-c1)/CLK_TCK);
 }
 {
  c1=clock();

  for (long i=0; i<Count; i++)
      for (long j=0; j<1000; j++)
          f2();

  c2=clock();
  printf("f2(): %ld ths calls per %.1f sec\n", Count, double(c2-c1)/CLK_TCK);
 }
}

