/*
	pingerd - pinger daemon
	Copyright (c) by Alexey Semenov
*/

#include "pingerd.h"

#ifdef USE_SNMP
#include "snmp_trap.h"
#endif

//---------------------------------------
void daemonize (void)
{
	switch (fork ()) {
        case 0: /* I am the child. */
		setsid ();
		break;
        case -1: /* Failed to become daemon. */
		printf ("Can't fork()");
		exit (1);
        default: /* I am the parent. */
		exit (0);
        }
}
//---------------------------------------
void get_time_string (char *time_string)
{
	char *month, *date, *hour, *minute, *time_strin;
	time_t timv = time (0);
	time_strin=ctime ( &timv );
        time_strin[strlen (time_strin)-1]=0;

	strtok(time_strin," ");
        month=strtok(NULL," ");
        date=strtok(NULL," ");
        hour=strtok(NULL,":");
        minute=strtok(NULL,":");

	strcpy (time_string, date);
	strcat (time_string," ");
	strcat (time_string,month);
	strcat (time_string," ");
	strcat (time_string,hour);
	strcat (time_string,":");
	strcat (time_string,minute);
}
//---------------------------------------------------
int is_node_live (char *node)
{
	char ping[]=PING_CMD;
	char ping_cmd[128];
	char p1[]=" >";
	char p2[]=PING_PIPE;
	char p3[]=" 100% packet lo";
	FILE *fl1;
	char temp_string[512];
	int flag;

	flag=TRUE;
	memset (ping_cmd, 0, sizeof (ping_cmd));

	strcat (ping_cmd, ping);
	strcat (ping_cmd, node);
	strcat (ping_cmd, p1);
	strcat (ping_cmd, p2);
	strcat (ping_cmd, " &");
/*
#ifdef DEBUG
        printf ("Func is_node_live: system(%s)\n",ping_cmd);
#endif
*/
	system (ping_cmd);
	if ((fl1=fopen(PING_PIPE,"r"))==NULL) {
		fprintf (stderr,"Can't open pipe afer running ping.\n");
		exit (1);
	}
	while ((fgets(temp_string, 511, fl1))!=NULL) { 
		if ((strstr(temp_string, p3))!=NULL) {
			flag=FALSE;
			break;
		}
	}
	fclose(fl1);
	return (flag);
}
//---------------------------------------------------
void ping_node(char *p_temp_string)
{
	int lnode, need_upd;
	FILE *fl2, *fl3;
	char temp_string[512];
	char temp_string1[512];
	char time_str[64];
	char cur_alarm[512];
	char *temp_string_p, *file_buffer;
	struct stat statv;
	int need_write_log, need_write_hot;

	lnode=0;
	need_upd=0;
	need_write_log=1;
	need_write_hot=1;

	memset (cur_alarm, 0, sizeof(cur_alarm));
	get_time_string(time_str);

#ifdef DEBUG
	printf ("Pinging %s...",p_temp_string);
#endif

	lnode=is_node_live(p_temp_string);

#ifdef DEBUG
	if (lnode) { 
		printf ("NODE_UP\n");
	} else { 
		printf ("NODE_DOWN\n");
	}
#endif
	if (lnode) { 
		need_write_log=0;
	}

	if ( access (FILE_HOT_ALARM, R_OK) == 0 ) {
		fl2=fopen (FILE_HOT_ALARM,"r");
	} else {
		fl2=fopen (FILE_HOT_ALARM,"w+");
	}

	if (stat(FILE_HOT_ALARM,&statv)!=0) {
		perror (FILE_HOT_ALARM); exit (1);
	} 
	if ((file_buffer=calloc(statv.st_size+1000,1))==NULL) {
		printf ("malloc error\n");exit (1);
	}
	memset (file_buffer, 0, sizeof(file_buffer));
//----------------------------------------------------
/*
#ifdef DEBUG
        printf ("Updating files...\n");
#endif
*/
	while ((fgets(temp_string, sizeof(temp_string)-1, fl2))!=NULL) {
		strcpy (temp_string1, temp_string);

/*
#ifdef ADD_DEBUG
                printf ("Read string %s\n",temp_string1);
#endif
*/
		strtok ( temp_string1, " ");
		strtok ( NULL, " ");
		strtok ( NULL, " ");
		temp_string_p = strtok ( NULL, " ");

		if ( strcmp ( temp_string_p, p_temp_string ) == 0 ) {
			if (lnode) {
				need_write_log=1;
				need_write_hot=0;
				need_upd=1;		     
				continue;
			} else {
				need_write_hot=0;
				need_write_log=0;
			}
		}

		strcat (file_buffer, temp_string);
	}

	fclose (fl2);
//----------------------------------------------------
	strcat(cur_alarm, time_str);
	strcat(cur_alarm, " ");
	strcat(cur_alarm, p_temp_string);
	strcat(cur_alarm, " ");
	if (lnode) strcat(cur_alarm, " NODE_UP");
	else strcat(cur_alarm, " NODE_DOWN");

	if ((need_write_hot) && (!lnode)) {
		// fprintf(fl1,"%s\n",cur_alarm);
		sprintf( temp_string, "%s\n",cur_alarm);
		strcat (file_buffer, temp_string );
		need_upd=1;
	}

	if (need_upd ) {
		fl2=fopen (FILE_HOT_ALARM,"w+");
		fprintf (fl2, "%s", file_buffer);
		fflush (fl2);
		fclose (fl2);
	}

	free (file_buffer);

	if (need_write_log) {
		fl3=fopen (LOG_FILE_NAME,"a");

#ifdef USE_SNMP
		send_trap (SNMPTRAPD_HOST, COMMUNITY, SNMP_MAJ, SNMP_MIN, cur_alarm, SNMP_SOURCE);
#endif

		fprintf (fl3,"%s\n",cur_alarm);
		fflush (fl3); 
		fclose (fl3);
	} 
}
//=================================================== MAIN
int main(int argc, char **argv, char **env)
{
	FILE *fl1;
	char temp_string[512];
	char *p_temp_string;
	int flag, delay;

	char msleep[]=";SLEEP";
	char remark[]=";";
	char ping_strt[]=";PINGER_START";
	char ping_stop[]=";PINGER_STOP";

	unlink (PING_PIPE );
	if (mkfifo(PING_PIPE, 0600) != 0) {
		fprintf (stderr,"Can't create pipe.\n");
		exit (1);
	}

#ifndef DEBUG
	daemonize();
#endif

	while (1) {
		if ((fl1=fopen(FILE_NODES,"r"))==NULL) {
			fprintf (stderr,"Can't open node file.\n");
			exit (1);
		} 
		flag=0;

		while ((fgets(temp_string, sizeof(temp_string)-1, fl1))!=NULL) {
			p_temp_string=strtok(temp_string, " \t\n");
			if ((strncmp(p_temp_string, ping_strt, strlen(ping_strt)))==0) flag=1;
			if ((strncmp(p_temp_string, ping_stop, strlen(ping_stop)))==0) flag=0;

			if (((strncmp(p_temp_string, msleep, strlen(msleep)))==0) && (flag!=0) ) {
				p_temp_string=strtok(NULL, " \t\n");
				delay=atoi(p_temp_string);

#ifdef DEBUG
				printf ("sleep %d \n",delay);
#endif

				if (delay>0) sleep (delay);
				continue;
			}

			if ((strncmp(p_temp_string, remark, strlen(remark)))==0) continue;

			if (flag!=0) ping_node (p_temp_string);
		}
		fclose (fl1);
	}
}

/* end */


























