#!/usr/bin/perl

# remind ver 0.0.5
# Written by Alexey Semenov
#

use Time::Local;


$_ = localtime ( time  );                                                                       
split;  $year = $_[4];                                                                                 
                                                                                                       
%month_of_day = qw(Jan 01 Feb 02 Mar 03 Apr 04 May 05 Jun 06                                           
                   Jul 07 Aug 08 Sep 09 Oct 10 Nov 11 Dec 12);                                         
umask (0077);
                       
unless ( -w "$ENV{HOME}/.reminder" ) { print "You have no ~/.reminder directory. Create (Y/N)? ";
					$_ = <STDIN>; chomp; $_ = uc ($_);
					 unless ( $_ eq 'Y' )  { exit; }
					  mkdir ( "$ENV{HOME}/.reminder",0700);
					}

print "\n\nYou are above to create new message:\n";

print "Enter year \[$_[4]\]:";
my $year = <STDIN>;
chomp ($year);
$year=$_[4] unless ( $year );


print "Enter month \[$_[1]/$month_of_day{$_[1]}\]:";
$_ = <STDIN>; chomp;
my $month = '';
unless ( /\d\d/ ) { $month = $month_of_day{$_}; }
else  { $month = $_; }
if ( ( $month < 1 ) || ( $month > 12 )) { $month = $month_of_day{$_[1]}; }

$_[2]++;
print "Enter day \[$_[2]\]:";
$_ = <STDIN>; chomp;
my $date='';
unless ( /\d\d/ ) { $date= $_[2]; }
else  { $date = $_; }
if ( ( $date < 1) || ( $date >31 ) ) { $date= $_[2]; }

print "Enter time [10:30]: ";
$_ = <STDIN>; chomp;
my $time = '';
unless ( /\d\d:\d\d/ ) { $time = '10:30'; }
else { $time = $_; }

my $file = "$ENV{HOME}/.reminder/$year-$month-$date".'_'."$time".'.msg';
#print "\n$file\n";

print "Enter text, Ctrl-D for end...\n\n";
my @text = <STDIN>;

print "Save this message (Y/N) ? ";
$_ = <STDIN>; chomp; $_ = uc ($_);
unless ( $_ eq 'Y' )  { exit; }

open ( F, ">>$file" ) or die "Can't open $file: $!\n";

foreach ( @text ) {

print F $_;
}

close (F) or die "Can't close $file: $!\n";
print "\nMessage accepted\n\n";
