# Package encoding::trans
# Version 1.0
# Part of "WWW Cyrillic Encoding Suite"
# Get docs and newest version from
#	http://www.neystadt.org/cyrillic/
#
# Copyright (c) 1997-98, John Neystadt <http://www.neystadt.org/john/>
# You may install this script on your web site for free
# To obtain permision for redistribution or any other usage
#	contact john@neystadt.org.
#
# Drop me a line if you deploy this script on tyour site.

package encoding::trans;

$UCase {'KOI'} = "\377";
$LCase {'KOI'} = "ţ";
$UCase {'WIN'} = "Ũ";
$LCase {'WIN'} = "\377";
$UCase {'DOS'} = "";
$LCase {'DOS'} = "񦧨";

$tab{"KOI8"}="\377ţ";
$tab{"DOS"}="񦧨";
$tab{"ISO"}="";
$tab{"WIN"}="Ũ\377";
$tab{"VOL"}="ABVGDEZIJKLMNOPRSTUFXCW~Y'abvgdezijklmnoprstufxcw~y'\377";
$tab{"MAC"}="݆";
#	     1234567890123456789012345678901234567890123456789012345678901234567890

sub Trans {
	my ($Src, $Dst, $Buf) = @_;
	$Src = uc ($Src); $Src .= '8' if $Src eq 'KOI';
	$Dst = uc ($Dst); $Dst .= '8' if $Dst eq 'KOI';

	eval "\$Buf =~ tr/$tab{$Src}/$tab{$Dst}/";
	if ($Dst eq 'VOL') {
		$Buf =~s//YO/go; $Buf =~s//ZH/go; $Buf =~s//CH/go;
		$Buf =~s//SH/go; $Buf =~s//E\'/go; $Buf =~s//YU/go; 
		$Buf =~s//YA/go; $Buf =~s//yo/go; $Buf =~s//zh/go;  
		$Buf =~s//ch/go; $Buf =~s//sh/go; $Buf =~s//e\'/go; 
		$Buf =~s//yu/go; $Buf =~s/\377/ya/go;
	}
	$Buf;
}

sub LCase {
	my ($s, $Code) = @_;
	$Code = uc ($Code);
	eval ("\$s =~ tr/$UCase{$Code}/$LCase{$Code}/");
	$s;
}
