/*
  xrus - keyboard switcher/indicator
  Copyright (c) 1996 Alexander V. Lukyanov
  This is free software with no warranty.
  See COPYING for details.
*/
#include <config.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifdef HAVE_MOTIF
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/CascadeB.h>
#endif

#ifdef HAVE_LIBXAW
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#endif

#include "xrus.h"
#include "menu.h"
#include "props.h"
#include "altmap.h"

#if defined HAVE_MOTIF || defined HAVE_LIBXAW
Widget   menu;
Widget   menus[2]={0,0};

enum
{
   LOCK,
   PROPS,
   EXIT
};

static
void  menu_item_cb(Widget w,XtPointer closure,XtPointer call_data)
{
   switch((int)closure)
   {
   case LOCK:
      LockScreen();
      break;
   case PROPS:
      PropsPopup();
      break;
   case EXIT:
      cleanup();
      XtDestroyApplicationContext(app_context);
      app_context=NULL;
      break;
   }
}

static
XtCallbackRec  menu_cb[]=
{
   {menu_item_cb,0},
   {NULL}
};

static
void  popup_create(int n)
{
   if((menu=menus[n])!=NULL)
      return;

#ifdef HAVE_MOTIF
{
   Widget   altmap_menu;

   menu=menus[n]=XmCreatePopupMenu(switch_button[n],"menu",NULL,0);

   menu_cb[0].closure=(XtPointer)LOCK;
   XtVaCreateManagedWidget("lock",xmPushButtonWidgetClass,menu,XmNactivateCallback,menu_cb,NULL);
   menu_cb[0].closure=(XtPointer)PROPS;
   XtVaCreateManagedWidget("props",xmPushButtonWidgetClass,menu,XmNactivateCallback,menu_cb,NULL);

   altmap_menu=CreateAltMapMenu(menu,AppData.altMaps);
   if(altmap_menu)
   {
      XtVaCreateManagedWidget("altmap",xmCascadeButtonWidgetClass,menu,
         XmNsubMenuId,altmap_menu,
         NULL);
   }

   XtVaCreateManagedWidget("line",xmSeparatorWidgetClass,menu,NULL);
   menu_cb[0].closure=(XtPointer)EXIT;
   XtVaCreateManagedWidget("exit",xmPushButtonWidgetClass,menu,XmNactivateCallback,menu_cb,NULL);
}
#else
   menu=menus[n]=XtCreatePopupShell("menu",simpleMenuWidgetClass,switch_button[n],NULL,0);
   {
      static XtTranslations trans=None;
      if(trans==None)
	 trans=XtParseTranslationTable(
	    "<Btn3Down>: XawPositionSimpleMenu(menu)"
                       " MenuPopup(menu)");
      XtOverrideTranslations(switch_button[n],trans);
   }
   menu_cb[0].closure=(XtPointer)EXIT;
   XtVaCreateManagedWidget("exit",smeBSBObjectClass,menu,XtNcallback,menu_cb,NULL);
   XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
   CreateAltMapMenu(menu,AppData.altMaps);
   XtVaCreateManagedWidget("line",smeLineObjectClass,menu,NULL);
   menu_cb[0].closure=(XtPointer)LOCK;
   XtVaCreateManagedWidget("lock",smeBSBObjectClass,menu,XtNcallback,menu_cb,NULL);
   menu_cb[0].closure=(XtPointer)PROPS;
   XtVaCreateManagedWidget("props",smeBSBObjectClass,menu,XtNcallback,menu_cb,NULL);
#endif
}

static
void  popup_menu(XEvent *ev)
{
#ifdef HAVE_MOTIF
   XmMenuPosition(menu,&(ev->xbutton));
   XtManageChild(menu);
#endif
}
#endif /* HAVE_MOTIF || HAVE_LIBXAW */

void  XrusMenuCreate()
{
#if defined HAVE_MOTIF || defined HAVE_LIBXAW
   popup_create(0);
   popup_create(1);
#endif
}

void  XrusMenuPopup(Widget w,XEvent *ev,String *params, Cardinal *num_params)
{
#if defined HAVE_MOTIF || defined HAVE_LIBXAW
   popup_create(w==switch_button[1]);
/*   if((menus[0] && XtIsManaged(menu)) || (menus[1] && XtIsManaged(menus[1])))
      return;*/
   popup_menu(ev);
#endif
}
