;+
; Smart cyrillization V0.3beta 
; ToDo:
;     Auto-conversion of russian coding flavours
;-
(require 'cl)
(eval-when-compile (load "cl-extra"))


(defvar cyr-main-swc-key  [kp-enter]) ; main switch key

(defvar cyr-group-swc-key  [kp-3])    ; map group switch key

(defvar cyr-double-click   1.0)  ; maximum secs between "double click"

(defvar cyr-reset-timeout   10)  ; secs before auto-reset of typed segment

(defvar cyr-max-distance     3)  ; max dist. between chars in one typed seg.

(defvar cyr-max-undo-depth 100)  ; max depth in undo handling

(defvar cyr-max-seg-dist   100)  ; max looking typed segment length





(standard-display-european 1)

(make-variable-buffer-local 'cyr-st)

(defun cyr-st () "Lazy creating current buffer cyrillic state"
  (if (and (boundp 'cyr-st) cyr-st) cyr-st (setq cyr-st 
  (list (cyclic (cyclic  ; english mappings
 '(eng   
   "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz{[}]><+=~`|\\.,:;\"'"))
		(cyclic  ; russian mappings
 '(koi8    
   ".,:;\"'")
 '(koi8.pc 
   "+=~`|\\")))
	(cyclic 0 0 0)    ;; swc times                            
	(cyclic 0 0)      ;; chr times
	(cyclic 0 0)))))  ;; chr posit. 

;; List cyclyc utilities
(defun cyclic (&rest l)  (setq l (copy-list l)) (setcdr (last l) l))
(defun roll-fw-car  (l)  (setcar l  (cdar l))  (car l))
(defun roll-bw-car  (l)  (let ((p (car l))) 
			   (while (not (eq (cdr (roll-fw-car l)) p)))
			   (car l)))
;; Timers & positions
(defun current-time-decs () (let ((tm (current-time))) 
			      (+ (float (second tm)) 
				 (/ (float (third tm)) 1000000)))) 
(defun cyr-mark-t   (l)     (setcar (roll-bw-car l) (current-time-decs)))
(defun cyr-t-ok-p   (l int) (< (- (car l) (cadr l)) int))
(defun cyr-mark-pos (l)     (setcar (roll-bw-car l) (point)))
(defun cyr-pos-ok-p (l int) (< (abs (- (car l) (cadr l))) int))

;; Some useful information queries
(defun cyr-curr-name ()  (format "      -->    %s" (first  (caaar  (cyr-st)))))
(defun cyr-curr-keys ()  (second (caaar  (cyr-st))))
(defvar cyr-default-keys  (cyr-curr-keys))
(defun cyr-hide-keys ()  (second (caadar (cyr-st))))
(defvar cyr-russian-keys  (cyr-hide-keys))

(defun cyr-swc-t-ok-p () (cyr-t-ok-p (second (cyr-st)) cyr-double-click))
(defun cyr-swc-t-ok2-p() (and (cyr-swc-t-ok-p) 
			      (cyr-t-ok-p (cdr (second (cyr-st))) 
					 cyr-double-click)))
(defun cyr-chr-t-ok-p () (cyr-t-ok-p (third (cyr-st)) cyr-reset-timeout))
(defun cyr-swc-before-last-chr () 
  (> (first (second (cyr-st))) (second (third (cyr-st)))))

;; Remap keyboard
(let* ((i -1) (n (length cyr-default-keys)))
  (while (< (incf i) n)     
    (global-set-key (char-to-string (aref cyr-default-keys i))
		    (eval `#'(lambda (n) (interactive "p") 
			       (cyr-mark-t (cddr (cyr-st)))
			       (cyr-mark-pos (cdddr (cyr-st)))
			       (cyr-before-input (point))
			       (let ((last-command-char 
				      (aref (cyr-curr-keys) ,i))) 
				 (self-insert-command n)))))))

(global-set-key cyr-main-swc-key  ;; Mode switch key
		#'(lambda (n) (interactive "p")
		    ; first we regard swc normal key
		    (cyr-mark-t (cddr (cyr-st)))
		    (cyr-mark-pos (cdddr (cyr-st)))
		    ; now we reset typed segment when needed
		    (if (or (not (cyr-chr-t-ok-p)) 
			    (not (cyr-pos-ok-p (fourth (cyr-st))  
					       cyr-max-distance)))
			(cyr-reset-undo))
		    ; second we mark specific event
		    (cyr-mark-t (cdr (cyr-st)))
		    ; now we compute what we have to switch
		    (if (or (not (cyr-swc-t-ok-p)) (cyr-swc-t-ok2-p))
			(roll-fw-car (cyr-st)))
		    (if (cyr-swc-t-ok-p) 
			 (cyr-toggle-undo))
		    (message (cyr-curr-name))))

(global-set-key cyr-group-swc-key ;; Cyr-mode group rolling key
		#'(lambda (n) (interactive "p") 
		    (roll-fw-car (car (cyr-st)))
		    (message (cyr-curr-name))))

(defun char-at (pos) (aref (buffer-substring pos (1+ pos)) 0)) 

(defun cyr-before-input (pos)
  (if (or (not (cyr-chr-t-ok-p)) (cyr-swc-before-last-chr))
      (cyr-reset-undo))
  (if (not (cyr-pos-ok-p (fourth (cyr-st)) cyr-max-distance)) 
      (progn
	(cyr-reset-undo)
	(if (> (point-max) (point-min))
	    (let ((tp (cond ((= pos (point-min))                  pos)
			    ((= pos (point-max))              (1- pos))
			    ((position (char-at pos) " \t\n") (1- pos))
			    (t                                    pos))))
	      (if (and (position (char-at tp) (cyr-hide-keys))
		       (not (position (char-at tp) (cyr-curr-keys))))
		  (roll-fw-car (cyr-st))))))))

;;----------- Text toggle code -------------
;; NIL are correct initial values for ones:
(make-variable-buffer-local 'cyr-toggle-lv)
(make-variable-buffer-local 'cyr-undo-lv)

(defun cyr-reset-undo ()
  (setq cyr-toggle-lv nil
	cyr-undo-lv (undo-start)))

(defun cyr-toggle-char (char)
  "Toggle char cyr-mode"
  (let ((c (position char (cyr-curr-keys)))
	(h (position char (cyr-hide-keys))))
    (cond (c (aref (cyr-hide-keys) c))
	  (h (aref (cyr-curr-keys) h))
	  (t char))))

(defun cyr-toggle-region (from to)
  "Toggle cyr-mode for given region"
    (and (<= (point-min) from) (>= (point-max) to)
	 (let ((pos (point)))
	   (goto-char from)
	   (let ((s (buffer-substring from to)))
	     (save-excursion
	       (delete-char   (- to from))
	       (insert-string (map 'string #'cyr-toggle-char s))))
	   (goto-char pos))))

(defun cyr-toggle-undo-el (uel) 
  "Toggle cyr-mode for undo list element"
  (if (and (consp uel) (stringp (car uel)))
      (setcar uel (map 'string #'cyr-toggle-char (car uel)))))

(defun cyr-undo-depth ()
  "Compute last typed undo segment length"
  (let ((n 0) (u (undo-start)))
    (while (and u (< n cyr-max-undo-depth) (not (eq u cyr-undo-lv))) 
      (if (consp (car u))
	  (incf n))
      (pop u))
    (1+ n)))

(defun cyr-toggle-undo-buf ()
  "Toggle cyr-mode by means undo segment"
  (let ((top (undo-start)))
    (primitive-undo (cyr-undo-depth) top)
    (undo-boundary)
    (let ((ul (undo-start)))
      (while (and ul (not (eq ul top)))
	(cyr-toggle-undo-el (car ul))              
	(pop ul)))
    (undo)))

(defun cyr-toggle-undo ()
  "Toggle cyr-mode for last typed text"
  (if cyr-toggle-lv
      (mapcar #'(lambda (l) (cyr-toggle-region (car l) (cdr l))) 
	      cyr-toggle-lv)
    (let ((start (- (point) cyr-max-seg-dist))
	  (stop  (+ (point) cyr-max-seg-dist)))
      (if (<  start (point-min)) (setq start (point-min)))
      (if (>  stop  (point-max)) (setq stop  (point-max)))
      (let ((buf-old (buffer-substring start stop)))
	(cyr-toggle-undo-buf)
	(let ((buf-new (buffer-substring start stop))  
	      (i 0)  (err nil))
	  ;; Accumulate toggle segments
	  (while (and (not err) (< i (- stop start)))
	    (let ((oc (aref buf-old i)) (nc (aref buf-new i))) 
	      (if (not (= oc nc))
		  (if (= (cyr-toggle-char oc) nc)
		      (let ((pos (+ start i)))
			(push (cons pos (1+ pos)) cyr-toggle-lv))
		    (setq err t)))
	      (incf i))))))))

;;---- Make cyrillic characters syntax pairs and entries
(let ((i -1))
  (while (< (incf i) (* 2 (- 33 1))) ; no "yo" character
    (modify-syntax-entry (aref cyr-russian-keys i) "w  ")
    (if (eq 0 (% i 2)) (set-case-syntax-pair 
			(aref cyr-russian-keys i)
			(aref cyr-russian-keys (1+ i))
			(standard-case-table)))))

(defun isearch-printing-char ()
  "Redefine ISEARCH function to help it feel cyrillic characters"
  (interactive)
  (isearch-process-search-char 
   (let ((i (position last-command-event cyr-default-keys))) 
     (if i (aref (cyr-curr-keys) i) last-command-event))))

