/*
  xrus - keyboard switcher/indicator
  Copyright (c) 1996 Alexander V. Lukyanov
  This is free software with no warranty.
  See COPYING for details.
*/
#include <config.h>

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#ifdef HAVE_MOTIF
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#endif

#ifdef HAVE_LIBXAW
#include <X11/Xaw/SmeBSB.h>
#endif

#include "altmap.h"
#include "xrus.h"
#include "keycomb.h"

#include "xalloca.h"

void  altmap_CB(Widget w,XtPointer closure,XtPointer call_data)
{
   ToLatKeys.Fire();

   XSync(disp,False);

   fflush(stderr);
   switch(fork())
   {
   case(-1):
      fprintf(stderr,"%s: fork() failed - %s\n",program,strerror(errno));
      break;
   case(0):
      /* child */
      execlp("xmodmap","xmodmap",(char*)closure,NULL);
      fprintf(stderr,"%s: execlp(xmodmap) failed - %s\n",program,strerror(errno));
      fflush(stderr);
      _exit(1);
   default:
      /* parent */
      ;
   }
}

Widget   CreateAltMapMenu(Widget parent,const char *altmap)
{
#if defined HAVE_MOTIF || defined HAVE_LIBXAW
   int   altmap_count=0;
#ifdef HAVE_MOTIF
   Widget   menu_pane=XmCreatePulldownMenu(parent,"altmap_menu",NULL,0);
#endif
   Widget   button;
   char     *scan=alloca(strlen(altmap)+1);
   char     *file;
   char     button_name[32];

   strcpy(scan,altmap);

   for(;;)
   {
      /* ignore leading spaces */
      while(*scan && isspace(*scan))
         scan++;
      if(!*scan)
         break;

      file=scan;

      /* track down the end of file name */
      while(*scan && !isspace(*scan))
         scan++;

      if(*scan)
         *scan++=0;

      /* add the item to the menu_pane */
      sprintf(button_name,"altmap%d",altmap_count++);
#ifdef HAVE_MOTIF
      button=XmCreatePushButton(menu_pane,button_name,NULL,0);
      XtAddCallback(button,XmNactivateCallback,altmap_CB,strdup(file));
      XtManageChild(button);
#elif defined HAVE_LIBXAW
      button=XtVaCreateManagedWidget(button_name,smeBSBObjectClass,parent,NULL);
#endif
   }

#ifdef HAVE_MOTIF
   if(altmap_count==0)
   {
      XtDestroyWidget(XtParent(menu_pane));
      menu_pane=NULL;
   }
   return menu_pane;
#endif
#endif /* HAVE_MOTIF || HAVE_LIBXAW */
#ifndef HAVE_MOTIF
   return NULL;
#endif
}
