
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>

char debug=3;
/************************************************************************
 * ᫨ ᫥㥬 䠩 让,  ⭮  ⮨    
 * ⮡ ᭨ ஢.   ப   
 * ᫥饥   㬮砭 ⢮ ᨬ쭮 뢠 ᨬ.
 */
unsigned int total_count,          /* number od chars already readen
																		*/
          max_total_count=52000;   /* number of chars to read from a
                                    * file must not be morethen
																		*  max_total_count
																		*/
/*  祭 室 䠩 뢠 ᨬ  ࠢ 
 * ࠭ ।騬  ।,   ஢ ⠪ 
 * ⨯筠,    ᪫⥫쭮 筠
 */
char newchar,                       /* The char is readen just now
																		 */
		 lastchar,                      /* The char has been readen just before
																		 */
		 /*  ਧ     ஢
			*/
		 lastcap[16],                   /* Is the char readen before
																		 * a capital letter in some codings?
																		 */
		 newcap,                        /* is a new charchar
																		 * a capital letter?
																		 */
		 lastletter[16], newletter;     /* and which a letter?
																		 */
unsigned char code_num;              /* current coding table number */
unsigned char final_code_num;        /* The result: The best appropriate
																		 * coding table number */

unsigned char num_of_cod=0;         /* total number of coding tables */
int cyr_count[16];         /* number of cyrillic text (non-)specific
																		* biletter substrings readen for a code_num
																		*/
    char codenames[16][40];         /* names of code tables */

/* 騥 ப (   ஢, ᥣ num_of_cod)   饥
 * ⢮ । ।  䠩 RECODE.BAS.
 */

char  TO_INTERNAL[16][256];         /* 16 strings of length 256 such,
							                      * that internal_code_of_current_char
                                    * =TO_INTERNAL[code_num][char_num];
																	  */
FILE *tst;
int pos;


/*         ਧ TO_CAPITAL
 ( ਫ᪨ 㪢 =5, 宦     < 128 =1
                        =6, 宦     < 128 =2
                   ࠧ =7, 稥   < 128 =3) */
/*
	 TO_CAPITAL code:

                           | Char code < 128 |  Char code > 128
	  -----------------------+-----------------+-------------------
	  Capital like cyrillic  |       1         |       5
	  Small   like cyrillic  |       2         |       6
	  Other                  |       3         |       7
					                  */
char TO_CAPITAL [256]={
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1,
/* for some Caucasian languages "I" is not alwys capital */
 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 3,
/* for some cyrillic languages probably "Y" may be used for a small letter */
 3, 3, 2, 2, 2, 2, 2, 2, 3, 2, 2, 2, 2, 2, 2, 2,
/* for some cyrillic languages prefix "a" usually appears before capitalized */
/* word, for others "h" probably  may be used as capital */
 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3,
 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 5, 5,
 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6};

/*           ਧ TO_LETTER:
 1-32 - 㪢 ᪮ 䠢 -  宦  ⠭,
33-47 - \"e  㣨 㪢  ISO 8859-5  ⠪ ⨭᪨ 㪢, 宦    ⠭,
   45 - 稥 ⨭᪨ 㪢, 騥  ᫮ ਫ᪨ 몮
   48 - ⠫ ⨭᪨ 㪢,  騥  ᫮ ਫ᪨ 몮
   49 - ஡   ९,
   50 - । ਬ몠騥  ᫮   騥  ⥪
           128,
   51 - ।  ⥪ ᨬ   128,
   52 - 稥 ਫ᪨  ࠢ騥 ᨬ ( 㬥஢)
*/

/*       TO_LETTER code:

	   Chars                 |      Codes
	-------------------------+----------------------
  Russian letters A-YA     |     1 - 32
	and similar latin letters|
	-------------------------+----------------------
	 \"E and other cyrillic  |    33 - 44,46,47
	letters ISO 8859-5       |
	and similar latin letters|
	-------------------------+----------------------
	Latin letters  usual     |       45
	for some cyrillic        |
	languages                |
	-------------------------+----------------------
	The other latin letters  |       48
	-------------------------+----------------------
	The space and  another   |       49
  word delimiters          |
	-------------------------+----------------------
	Digits and symbols not   |       50
	adjacent to words        |
	-------------------------+----------------------
	Unusual for text chars   |       51
	with codes < 128         |
	-------------------------+----------------------
	Non-documented cyrillic  |       52
  and control chars        |
*/

unsigned char TO_LETTER[256]={
51, 51, 51, 51, 51, 51, 51, 51, 49, 51, 49, 51, 49, 49, 51, 51,
51, 51, 51, 51, 51, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,
49, 49, 49, 50, 50, 50, 50, 49, 49, 49, 50, 50, 49, 49, 49, 50,
50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 49, 49, 49, 50, 49, 49,
50,  1,  3, 18, 48,  6, 45, 48, 14, 38, 48, 11, 48, 13, 48, 15,
/*   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O
 P   Q   R   S   T   U   V   W   X   Y   Z    */
17, 45, 48, 37, 19, 48, 48, 45, 22, 45, 48, 49, 49, 49, 49, 49,
49,  1, 48, 18, 48,  6, 48, 48, 45, 38, 48, 45, 48, 19, 16, 15,
/*'  a   b   c   d   e   f   g   h   i   g   k   l   m   n   o
 p   q   r   s   t   u   v   w   x   y   z    */
17, 45, 48, 37, 48,  9, 48, 45, 22, 20, 48, 49, 49, 49, 49, 49,
52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52,
49, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 49, 46, 47,
 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
49, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 49, 46, 47
};

/*  The same does not work:
unsigned char TO_LETTER[]=
"\063\063\063\063\063\063\063\063\061\063\061\063\061\061\063\063\
\063\063\063\063\063\062\063\063\063\063\063\063\063\063\063\063\
\061\061\061\062\062\062\062\061\061\061\062\062\061\061\061\062\
\062\062\062\062\062\062\062\062\062\062\061\061\061\062\061\061\
\062\001\003\022\060\006\055\060\016\046\060\013\060\015\060\017\
\021\055\060\045\023\060\060\055\026\055\060\061\061\061\061\061\
\061\001\060\022\060\006\060\060\055\046\060\055\060\023\020\017\
\021\055\060\045\060\011\060\055\026\024\060\061\061\061\061\061\
\064\064\064\064\064\064\064\064\064\064\064\064\064\064\064\064\
\064\064\064\064\064\064\064\064\064\064\064\064\064\064\064\064\
\061\041\042\043\044\045\046\047\050\051\052\053\054\061\056\057\
\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017\020\
\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037\040\
\001\002\003\004\005\006\007\010\011\012\013\014\015\016\017\020\
\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037\040\
\061\041\042\043\044\045\046\047\050\051\052\053\054\061\056\057";
*/
char	*frequently_next[53] =
{ "",
        /*  -> . */
 "\001\002\003\004\005\007\010\012\013\014\015\016\020\021\022\023\026\030\031\040\061",
        /*  ->  */          "\001\006\011\017\024\034",
        /*  -> . */       "\001\006\011\016\017\021\024\034\061",
        /*  -> . */        "\001\006\011\017\021\024\034\061",
        /*  -> . */        "\001\006\011\016\017\024\034\061",
        /*  -> . */
"\002\003\004\005\010\012\013\014\015\016\020\021\022\023\026\031\061",
        /*  ->  */              "\001\011",
        /*  -> . */        "\001\005\006\011\016\024\034\061",
        /*  -> . */
"\003\004\005\010\012\013\014\015\016\021\022\023\030\031\040\061",
        /*  -> . */         "\005\011\014\016\023\034\061",
        /*  -> . */     ",1\006\011\013\014\017\022\023\024\034\061",
        /*  -> . */
"\001\004\005\006\011\014\015\016\017\023\024\026\034\035\036\040\061",
        /*  -> . */         "\001\006\011\017\024\034\061",
        /*  -> . */
"\001\004\005\006\011\015\016\017\022\023\024\030\034\035\036\040\061",
        /*  -> . */
"\002\003\004\005\010\012\013\014\015\016\020\021\022\023\026\031\061",
        /*  -> . */        "\001\006\011\017\023\024\034\061",
        /*  -> . */
"\001\004\005\006\011\013\014\015\016\017\022\023\024\034\061",
        /*  -> . */
"\001\006\011\013\014\016\017\022\023\024\034\035\040\061",
        /*  -> . */
"\001\003\006\011\013\014\016\017\023\024\034\035\036\061",
        /*  -> . */
"\003\004\005\010\012\013\014\015\016\020\021\022\023\026\030\031\061",
        /*  */                    "",
        /*  -> . */          "\001\011\017\023\024\061",
        /*  ->  */              "\001\011",
        /*  ->  */           "\001\006\011\024\034",
        /*  -> . */        "\001\006\011\013\014\023\034\061",
        /*  */                    "",
        /*  */                    "",
        /*  -> . */
"\004\005\013\014\015\016\020\021\022\023\031\061",
        /*  -> . */               "\061",
        /*  ->  */          "\005\013\014\015\016\023",
        /*  */                    "",
        /*  -> . */            "\003\016\022\061",
        /*  */                    "",
        /*  */                    "",
        /*  */                    "",
        /*  */                    "",
        /* I */                    "",
        /* S */                    "",
        /*  */                    "",
        /* J */                    "",
        /*  */                    "",
        /*  */                    "",
        /*  */                    "",
        /*  */                    "",
        /* W */                    "",
        /*  */                    "",
        /*  */                    "",
        /* z */                    "",
        /* . ->  */
 "\001\002\003\004\005\006\010\011\012\013\014\015\016\017\020\021\022\023\024\026\030\031\036\040",
        /* 1 */                    "",
        /*  */                    "",
        /*  */                    "",
};

char	*rarely_next[53] =
{ "",
        /*  -> */                 "",
        /*  -> JW */           "\012\025\031\050\055",
        /*  -> W */          "\002\012\025\047\056\055",
        /*  -> J */
 "\007\010\012\025\027\031\032\041\047\050\056",
        /*  -> JW */         "\012\025\032\047\050\055\056",
        /*  -> I */          "\034\035\044\045\047\056",
        /*  -> IJW */
 "\010\012\015\020\025\026\031\032\033\037\040\041\044\045\050\055\056\0039",
        /*  -> JW */      "\012\025\027\031\032\041\044\047\050\055",
        /*  ->  */              "\033\035",
        /*  -> JW֙ */
 "\032\033\035\036\041\042\043\044\047\050\051\052\053\054\055\056\057",
        /*  -> W */       "\002\012\025\032\040\044\047\055\056",
        /*  -> */                 "",
        /*  -> JW */       "\010\012\032\033\041\044\047\050\055",
        /*  -> */                 "",
        /*  -> W */              "\033\055",
        /*  -> JW */     "\003\007\010\012\025\037\047\050\054\055\056",
        /*  ->  */              "\047\056",
        /*  ->  */             "\012\047\056",
        /*  -> W */          "\007\010\012\032\047\055",
        /*  -> I */           "\033\041\045\047\056",
        /*  -> JW */
 "\002\003\004\005\007\010\012\013\020\026\027\030\031\032\033\035\037\040\041\044\047\050\055\056",
        /*  -> S */       "\007\012\025\032\037\041\044\046\0039",
        /*  -> JSW */
 "\002\007\010\016\020\025\027\030\031\032\033\044\046\047\050\055\056",
        /*  -> JW */
 "\002\004\005\007\010\012\020\025\026\032\040\044\047\050\055\056",
        /*  -> W */
 "\007\010\012\025\027\032\037\040\041\044\047\055\056",
        /*  -> SW֐ */
 "\002\003\004\005\007\010\012\013\014\015\020\021\022\025\026\027\030\031\033\042\043\044\046\047\051\052\053\054\055\056\057\064",
        /*  -> IJSW֑ */
 "\012\013\020\022\025\027\030\031\033\035\042\043\044\045\046\047\050\051\052\053\054\055\056\057\064",
        /*  -> IJSW֚ */
 "\017\033\035\036\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057",
        /*  -> JS֚ */
 "\033\035\042\043\044\046\047\050\051\052\053\054\056\057",
        /*  -> JS֚ */
 "\033\034\035\037\041\042\043\044\046\047\050\051\052\053\054\056\057\064",
        /*  -> IJSW֔ */
 "\003\020\025\033\034\036\040\042\043\045\046\047\050\051\052\053\054\055\056\057",
        /*  -> IJSW֓ */
 "\011\017\024\025\033\036\041\042\043\045\046\047\050\051\052\053\054\055\056\057",
        /*  -> IJSW֓ */
 "\006\011\024\032\033\034\035\036\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057\064",
        /*  -> IJSW֐ */
 "\002\003\004\005\007\010\012\013\014\015\016\020\021\022\023\025\026\027\030\031\032\033\034\035\036\037\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057\064",
        /*  -> IWՙ */
 "\032\033\034\035\036\037\040\041\042\044\045\047\055\056\064",
        /*  -> ֚ */
 "\033\034\035\041\042\043\051\052\053\054\057\064",
        /* I -> ֚ */
 "\033\034\035\041\042\043\051\052\053\054\057",
        /* S -> ՙ */      "\012\032\033\034\035\036\037\040\041\042",
        /*  -> ֚ */
 "\033\034\035\041\042\043\051\052\053\054\057\064",
        /* J -> W */
 "\002\012\020\025\027\032\033\034\035\036\037\040\041\044\047\055\056",
        /*  -> IW */
 "\032\033\034\035\036\037\040\041\044\045\047\055\056\064",
        /*  -> IW */
 "\032\033\034\035\036\037\040\041\044\045\047\055\056\064",
        /*  -> IJW */
 "\002\004\005\007\010\012\020\025\026\032\033\034\035\036\037\040\041\044\045\047\050\055\056\064",
        /*  -> IWՙ */
 "\032\033\034\035\036\037\040\041\042\044\045\047\055\056\064",
        /* W -> J֚ */
 "\027\033, 27\034\035\037\040\041\042\043\050\051\052\053\054\057",
        /*  -> ֚ */
 "\033\035\041\042\043\051\052\053\054\057\064",
        /*  -> IJSW֐ */
 "\002\003\004\005\007\010\012\013\014\015\016\020\021\022\023\025\026\027\030\031\032\033\034\035\036\037\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057\064",
        /* z -> */                 "",
        /*  ->  */              "\033\035",
        /* 1 -> */                 "",
        /*  -> IJSW֐ */
 "\002\003\004\005\007\010\012\013\014\015\016\020\021\022\023\025\026\027\030\031\032\033\034\035\036\037\040\041\042\043\044\045\046\047\050\051\052\053\054\055\056\057\064",
        /*  -> S֚ */
 "\033\035\037\042\043\044\046\047\051\052\053\054\057"
};
void impossible (char *);
void readconfig (char*);
int hexnum ( int);
void addchar (char *, int);
/***********************************************************************/
int hexnum (int num)
{
if ( num < 48 )
{
printf ("Bad halphbyte %d in pos %d ", num, pos);
exit(1);
}
else if ( num < 58 )
{
  return (num-48);
}
else if ( num < 65 )
{
printf ("Bad halphbyte %d in pos %d ", num, pos);
exit(1);
}
else if ( num < 71 )
{
  return (num - 55);
}
else
{
printf ("Bad halphbyte %d in pos %d ", num, pos);
exit(1);
}
return(0);
}
/***********************************************************************/
void addchar (char *str, int num)
{
  str[strlen(str)+1]=0;
  str[strlen(str)]=num;
}
/***********************************************************************/
void impossible (char *s)
{
    extern int pos;
printf ("There must never be %s in pos %d ", s, pos);
exit(19);
}
/***********************************************************************/
void readconfig (char* FileName){
    unsigned int  m,n, charcode,  nextchar;
    FILE *handle;
    extern int pos;
    int  char_num=128, code_num=0;
    char status=1;  /* 0 - in comment before codename
		 * 1 - in eol before codename
		 * 2 - in codename
                 * 3 - in comment after codename
		 * 4 - in eol after codename
		 * 5 - hex table between bytes
		 * 6 - hex table inside byte
		 * 7 - after all
		 */
		/*  Initilise ascii part of TO_INTERNAL[][] */
  for(n=  0;n<128; n++) {for(m=  0;m<16; m++)TO_INTERNAL[m][n]=n;}
  for(n=128;n<256; n++) {for(m=  0;m<16; m++)TO_INTERNAL[m][n]=1;}
  pos=0;
  strcpy (codenames[0],"");
    /* open a file for input		  */
      if ((handle = fopen( FileName, "r"))!=NULL) {
         if(debug>3){puts("\nReading code tables from the RECODE.BAS:\n");}
        code_num = 0;
      while ( (!feof(handle)) && (status<7) )
      {nextchar=getc(handle);
        if(debug>4){printf("\tnextchar=%d\n",nextchar);}
        pos++;
         if(debug>5){printf("[case %d]",status);}
    switch(status)
        {
        case 0: /* in comment before codename  */
                   if((nextchar==10)||(nextchar==13)) status=1; break;
        case 1: /* in eol before codename      */
                            if(nextchar=='#')
                                    status=0;
                            else
                            if((nextchar!=10)&&(nextchar!=13)&&(nextchar!=8)&&(nextchar!=32))
                            {status=2; addchar(codenames[code_num],nextchar);}
                            break;
        case 2: /* in codename                 */
                            if(nextchar=='#')
                            status=0;
                           else
                            if((nextchar==10)||(nextchar==13))
                           impossible(" ':' expected after codename");
                     else if  ( nextchar==':' )
                                             {
                         if ( strcmpi (codenames[code_num],"END" ) ==0 )
                     {       status=7;
                         break;}
                         if(debug>3){
                          printf("\n\t\tLoading %s as codetable number %d ... ",
                          codenames[code_num], code_num);
                          }
			pos=0;
                         if ( code_num > 15 ) impossible("Too much code tables");
                              status=4;   }else
                            {addchar(codenames[code_num],nextchar);}
                            break;
        case 3: /* in comment inside codetable */
                  if((nextchar==10)||(nextchar==13)) status=4; break;
        case 4: /* in eol inside codetable     */
                            if(nextchar=='#')
                                    status=3;
                            else
          if((nextchar!=10)&&(nextchar!=13)&&(nextchar!=8)&&(nextchar!=32))
                            {status=6;
                            charcode=hexnum(nextchar);
                            }
                            break;
        case 5: /* hex table between bytes     */
                            if(nextchar=='#')
                                    status=3;
                            else
          if((nextchar!=10)&&(nextchar!=13)&&(nextchar!=8)&&(nextchar!=32))
                            {
                            charcode=hexnum(nextchar);
                                    status=6;}
                            break;
        case 6: /* hex table inside byte       */
                             charcode=(charcode <<4)|hexnum(nextchar);
                             status=5;
                             if ( TO_INTERNAL[code_num][charcode] !=1 )
                             {
  printf (" TO_INTERNAL[%d][%d] =%d<>%d?\n",
                   code_num, charcode, TO_INTERNAL[code_num][charcode], char_num );
                                    impossible(" double charcode ");
                             }
                              TO_INTERNAL[code_num][charcode]=char_num;
                             char_num++;if (char_num==256)
                             {code_num ++;num_of_cod ++;char_num=128;
                              strcpy (codenames[code_num],"");status=1;}
                            break;
        default:;/* printf("%d",status); impossible(" such status case");*/
			}}
      if (status==7 )
			{
        if(debug>1)puts ("\n\tRECODE.BAS succesfully loaded");
			}
      else
      impossible ("error loading RECODE.BAS");
     /* close the file 		    */
      fclose( handle );
    }else printf("File RECODE.BAS must be in the same directory as executable!\n\
     RECODE.BAS    ⮩  ४ਨ,   ணࠬ!");

for (code_num=0; code_num < num_of_cod; code_num++)
{
    lastletter[code_num]=49;
    lastcap[code_num]=3;
       if(debug>5){
   printf("\n\t Values of TO_INTERNAL[%d]: %s\n",code_num,codenames[code_num]);
  for (n=0; n < 256; n++)
  printf("%d\n",TO_INTERNAL[code_num][n]);}}
}
/***********************************************************************/
main(int argc, char *argv[]){
float reserve, tmp_counter=-1000.0;
float cyrillicity[16],cyrillic;
unsigned int tmp_count;
    FILE *handle;
    char OK,*EndOfDirName, *relative, *absolute, *codename;
    unsigned int  code_num=0,total_rus[16]={0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0};
    char FileName[80];
	if (argc==1)
  {printf("⥫ ⬠ ⮬᪮ ᯮ ਫ᪮ ஢ \n\
  ⥪⮢ 䠩 (Cyrillic Encoding Recognizer). 맮\n\n\t\tcycoreco <TestFileName>\n\n\
  砭, ।,  室   znamensk@ipsun.ras.ru\n\
  \n(c) ᪨ ࣥ ., 1996,   96-07-89406."); exit(0);}


		/* calculate the filename */
		strcpy (FileName, argv[0]);
		EndOfDirName  = strrchr ( FileName, 92 );
    if(EndOfDirName == NULL )
				{strcpy(FileName,"");}
				else
				{EndOfDirName[1]=0;}
		strcat(FileName, "RECODE.BAS");
    readconfig (FileName);

cyr_count[code_num]=0;
   if (argc>1){
   if( (tst=fopen(argv[1],"rb")) == NULL )
        {printf(" File %s not found",argv[1]);exit(10);}
        else
        {printf(" Loading %s ...\n",argv[1]);}}
for(total_count=0;(total_count < max_total_count)&&!feof(tst); total_count++)
{
	newchar=getc(tst);
    if(debug>4)
      {
      printf("newchar= %d\n",newchar);
      }
  if( newchar == EOF )
    {
    if(debug>2)
      printf("finished reading %s, %d byte",argv[1], total_count);
    break;
    }
       /* ॡ ஢ ந    ᨬ
	*/
  for ( code_num=0; code_num < num_of_cod;  code_num++)
		{
       /* We read the new (current) char from text and analise which coding table
	* allows it to be after the last one. We shall decide if the biletter
	* string
  */
    tmp_count=TO_INTERNAL [code_num][newchar];
    newcap = TO_CAPITAL [tmp_count ];
    newletter = TO_LETTER [tmp_count];
    if ( (tmp_count>175)&&(tmp_count<240) )
    { total_rus [code_num] = total_rus [code_num] +1;
    }
      if ( debug>4 )
      printf("%s: lastletter=%d, newletter=%d , lastcap=%d, newcap=%d, \n",
      codenames[code_num], lastletter[code_num], newletter, lastcap[code_num] ,newcap);
    if(((lastcap[code_num]==6)||(lastcap[code_num]==2))
          &&((newcap==5)||(newcap==1)))
		{
			/*  ᫥ 쪮 ; 㥬  1
			 * Capital after small is bad
			 * Penalty 1
			 */
      cyr_count[code_num]=cyr_count[code_num]-1;
      if ( debug>3 )
      {
        printf("%s: %d-\n",codenames[code_num],newchar);
      }
		}
       else if ((lastcap[code_num]>3)||(newcap>3)){
			 /*     砥       ᨬ
				*  孥 .
				* Codes more then 127 only
				*/
        if ( strchr( rarely_next[newletter],lastletter[code_num] )!=NULL )
				{
				/* ஢ 㥬
				 * Bad substring of two letters
				 */
        cyr_count[code_num]=cyr_count[code_num]-1;
      if ( debug>3 )
      {
        printf("%s: %d-\n",codenames[code_num],newchar);
      }
        } else {
        if ( strchr( frequently_next[newletter],lastletter[code_num] )!=NULL )
				{
				/* ஢ 塞
				 * Good substring of two letters
				 */
      if ( debug>3 )
      {
        printf("%s: %d+\n",codenames[code_num],newchar);
      }
        cyr_count[code_num]=cyr_count[code_num]+1;
				}
      } }
  /* ࠭塞  祭 ਧ
   */
    lastletter[code_num]=newletter;
    lastcap[code_num]=newcap;
		}
}
final_code_num=0;
/*  롨ࠥ   ஢
 */
for(code_num=0;code_num < num_of_cod; code_num++)
  {
   cyrillicity[code_num]=(1.00 *cyr_count[code_num])/total_rus [code_num];
   if(debug>2){
    printf("\n\t %s 祭 ਫ筮 %d / %d = %f;\n",
    codenames[code_num],cyr_count[code_num],
    total_rus [code_num],cyrillicity[code_num]);
   }
   if(cyrillicity[code_num]>tmp_counter)
   {final_code_num=code_num;tmp_counter=cyrillicity[code_num];}
  }


  reserve=100;
for(code_num=0;code_num < num_of_cod; code_num++)
     {if((cyrillicity[final_code_num]-cyrillicity[code_num]< reserve)
       &&(!(final_code_num == code_num)))
     reserve=cyrillicity[final_code_num]-cyrillicity[code_num];
     }
     printf("\n\t %s 祭 ਫ筮 ᨬ쭮: %f.\n",
     codenames[final_code_num], cyrillicity[final_code_num] );
   if(cyrillicity[final_code_num]>.9 ) absolute="᪨ ⥪⮢ 䠩";
   else if(cyrillicity[final_code_num]>.8 ) absolute="᪨  ⥪⮢ 䠩  த묨 祭ﬨ";
   else if(cyrillicity[final_code_num]>.4 ) absolute=" 䠩  ᫥묨 ࠣ⠬ ᪮ ⥪";
   else if(cyrillicity[final_code_num]>.2 ) absolute=" 䠩   ࠣ⠬ ᪮ ⥪";
   else  absolute=" 䠩";
  if (reserve<0.1) relative = "ࠩ ᮬ⥫쭮";
  else if (reserve<0.2) relative = "筮 ᮬ⥫쭮";
  else if (reserve<0.3) relative = "";
  else if (reserve<0.4) relative = " ⭮";
  else if (reserve<0.5) relative = "᪮॥ ᥣ";
  else if (reserve<0.6) relative = "ᮬ";
  else  relative = "";
 printf("\n\t %s %s\n\t\t %s  ஢ %s.\n",
        absolute, argv[1], relative, codenames[final_code_num]) ;
}
