// PINGERD - pinger daemon
// Written by Alexey Semenov
// swaj_@geocities.com, alexey_semenov@hotmail.com

#include "use_files.h"

#include <sys/types.h>
#include <stdio.h>
#include <sys/time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#define TRUE 1
#define FALSE 0
#define PING_CMD "/bin/ping -c2 "
#define PING_DEST_FILE "/tmp/pinger.tmp"

//---------------------------------------
void daemon (void)
    {
    switch (fork ())
        {
        case 0: /* I am the child. */
	    setsid ();
            break;

        case -1: /* Failed to become daemon. */
            printf ("Can't fork()");
            exit (1);

        default: /* I am the parent. */
            exit (0);
        }
    }
//---------------------------------------
get_time_string (time_string)
   char *time_string;
{
   char *month, *date, *hour, *minute, *time_strin;

        time_t timv = time (0);
        time_strin=ctime ( &timv );

        time_strin[strlen (time_strin)-1]=0;

   (void) strtok(time_strin," ");
        month=strtok(NULL," ");
        date=strtok(NULL," ");
        hour=strtok(NULL,":");
        minute=strtok(NULL,":");

   strcpy (time_string, date);
   strcat (time_string," ");
   strcat (time_string,month);
   strcat (time_string," ");
   strcat (time_string,hour);
   strcat (time_string,":");
   strcat (time_string,minute);
}

//---------------------------------------------------
int is_node_live (node)
  char *node;
{
  char ping[]=PING_CMD;

  char ping_cmd[128];

  char p1[]=" >";
  char p2[]=PING_DEST_FILE;
  char p3[]=" 100% packet lo";

  FILE *fl1;
  char temp_string[512];
  int flag;

  flag=TRUE;

   bzero (ping_cmd, 127);

   strcat (ping_cmd, ping);
   strcat (ping_cmd, node);
   strcat (ping_cmd, p1);
   strcat (ping_cmd, p2);

     system (ping_cmd);

       if ((fl1=fopen(PING_DEST_FILE,"r"))==NULL) { fprintf (stderr,"Can't open pinger.tmp file.\n");
                                                    exit (1); }
	while ((fgets(temp_string, 511, fl1))!=NULL) { 
	  if ((strstr(temp_string, p3))!=NULL) { flag=FALSE; break; }
  }
fclose(fl1);
return (flag);
}
//---------------------------------------------------
ping_node(p_temp_string)
  char *p_temp_string;
{
int lnode;
FILE *fl1, *fl2, *fl3;
char temp_string[512];
char temp_string1[512];
char time_str[64];
char cur_alarm[512];
char *temp_string_p;

int need_write_log, need_write_hot;

  lnode=0;
  need_write_log=1;
  need_write_hot=1;

  bzero (cur_alarm, 511);

 get_time_string(time_str);

//!!!!!!!!! uncomment for test mode

//  printf ("Pinging %s...",p_temp_string);
    lnode=is_node_live(p_temp_string);
//      if (lnode) printf ("NODE_UP\n");
//	else printf ("NODE_DOWN\n");

   if (lnode) need_write_log=0;

//----------------------------------------------------
   rename (FILE_HOT_ALARM, FILE_HOT_ALARM_TEMP);

 fl2=fopen (FILE_HOT_ALARM_TEMP,"r");
 fl1=fopen (FILE_HOT_ALARM,"a");
//----------------------------------------------------
   while ((fgets(temp_string, 511, fl2))!=NULL) {

	strcpy (temp_string1, temp_string);

     if ( ( (temp_string_p = strstr (temp_string1, p_temp_string) ) != NULL ) &&
              ( strcmp (strtok (temp_string_p, " "),p_temp_string)==0 ) ) {

       if (lnode) {  need_write_log=1;
                     need_write_hot=0;
                     continue; }
       else       {  need_write_hot=0;
                     need_write_log=0; }
     }
fputs (temp_string, fl1);
   }
//----------------------------------------------------
     strcat(cur_alarm, time_str);
     strcat(cur_alarm, " ");
     strcat(cur_alarm, p_temp_string);
     strcat(cur_alarm, " ");
     if (lnode) strcat(cur_alarm, " NODE_UP");
     else strcat(cur_alarm, " NODE_DOWN");

  if ((need_write_hot) && (!lnode)) fprintf(fl1,"%s\n",cur_alarm);
  if (need_write_log) {
     fl3=fopen (LOG_FILE_NAME,"a");
     fprintf (fl3,"%s\n",cur_alarm);
     fclose (fl3); } 

 fclose (fl1);
 fclose (fl2);
 unlink (FILE_HOT_ALARM_TEMP);

}
//=================================================== MAIN
int
main(argc, argv, env)
    int	    argc;
    char    *argv[];
    char    *env[];
{
  FILE *fl1;
  char temp_string[512];
  char *p_temp_string;
  int flag;

  char remark[]=";";
  char ping_strt[]=";PINGER_START";
  char ping_stop[]=";PINGER_STOP";

//!!!! comment to test mode !!!

daemon();

 while (1) {

  if ((fl1=fopen(FILE_NODES,"r"))==NULL) { fprintf (stderr,"Can't open node file.\n"); exit (1); } 

  flag=0;

  while ((fgets(temp_string, 511, fl1))!=NULL) {
    p_temp_string=strtok(temp_string, " \t\n");
      if ( (strncmp(p_temp_string, ping_strt, strlen(ping_strt)))==0) flag=1;
        if ( (strncmp(p_temp_string, ping_stop, strlen(ping_stop)))==0) flag=0;
          if ( (strncmp(p_temp_string, remark, strlen(remark)))==0) continue;

	    if (flag!=0) ping_node (p_temp_string);
    }
fclose (fl1);
  }
}
