
/* the linux semctl prototype is broken as is the definition
   of union semun in sys/sem.h. */

/*#if (defined (__linux__) && !defined(_SEM_SEMUN_UNDEFINED) ) || defined (__FreeBSD__) || defined (__NetBSD__) || defined (__OpenBSD__)*/

#ifdef HAVE_UNION_SEMUN
#	define	my_semun	semun
#else
union my_semun {
  int val;
  struct semid_ds *pid;
  unsigned short *array;
};
#endif

#include <stddef.h>
#include "mytype.h"

typedef struct {
  int offset;
  UINT4 data[CD_FRAMESAMPLES];
} myringbuff;

struct ringbuffheader {
  myringbuff *p1;
  myringbuff *p2;
  int offset;
  UINT4 data[CD_FRAMESAMPLES];
};

extern myringbuff **fill_buffer;
extern myringbuff **last_buffer;

#ifndef offsetof
#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif

#define RB_BASE ((myringbuff *)(((unsigned char *)fill_buffer) + offsetof(struct ringbuffheader,offset)))
#define entry_size (offsetof(myringbuff,data) + global.nsectors*CD_FRAMESIZE_RAW)

void set_total_buffers __PR((unsigned int num_buffers, int mysem_id));
const myringbuff *get_previous_read_buffer __PR((void));
const myringbuff *get_fill_buffer __PR((void));
myringbuff *get_next_buffer __PR((void));
myringbuff *get_oldest_buffer __PR((void));
void define_buffer __PR((void));
void drop_buffer __PR((void));
void drop_all_buffers __PR((void));
