/* os dependent functions */
#include "config.h"
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include "byteorder.h"
#include "lowlevel.h"
#include "global.h"
#include "sndconfig.h"

int init_soundcard(rate, bits)
	double rate;
	int bits;
{
#ifdef	ECHO_TO_SOUNDCARD
  if (global.echo) {
    if ((global.soundcard_fd = open(SOUND_DEV, O_WRONLY
#if	defined NONBLOCKING_AUDIO && defined O_NONBLOCK
                                                        | O_NONBLOCK
#endif
                                                       , 0)) == EOF) {
	perror("");
        fprintf(stderr, "Cannot open %s\n",SOUND_DEV);
        global.echo = 0;
    } else { 
#if defined(sun) || defined(__sun) || defined(__sun__)
#ifdef	SVR4
#include <sys/audioio.h>
#else
#include <sun/audioio.h>
#endif
        audio_info_t            info;

#if	defined	(AUDIO_INITINFO) && defined (AUDIO_ENCODING_LINEAR)
        AUDIO_INITINFO(&info);
        info.play.sample_rate = rate;
        info.play.channels = global.channels;
        info.play.precision = bits;
        info.play.encoding = AUDIO_ENCODING_LINEAR;
        info.play.pause = 0;
        info.record.pause = 0;
        info.monitor_gain = 0;
        if (ioctl(global.soundcard_fd, AUDIO_SETINFO, &info) < 0) {
	    fprintf(stderr, "Cannot init %s (sun)\n", SOUND_DEV);
	    global.echo = 0;
	}
#else
	fprintf(stderr, "Cannot init 44.1 KHz on %s (sun)\n", SOUND_DEV);
	global.echo = 0;
#endif
#endif
#if defined(UNIX_SOUND_SYSTEM)
	int dummy;
	int garbled_rate = rate;
	int stereo = (global.channels == 2);
	int format = bits == 8 ? AFMT_U8 :
        	(MY_LITTLE_ENDIAN ? AFMT_S16_LE : AFMT_S16_BE);
	int mask;

	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_GETBLKSIZE, &dummy) == -1) {
	    fprintf(stderr, "Cannot get blocksize for %s\n", SOUND_DEV);
	    global.echo = 0;
	}
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SYNC, NULL) == -1) {
	    fprintf(stderr, "Cannot sync for %s\n", SOUND_DEV);
	    global.echo = 0;
	}

	/* check, if the sound device can do the requested format */
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_GETFMTS, &mask) == -1) {
		perror("fatal error:");
		return -1;
	}
	if ((mask & format) == 0) {
		fprintf(stderr, "sound format (%d bits signed) is not available\n", bits);
		if ((mask & AFMT_U8) != 0) {
			bits = 8;
			format = AFMT_U8;
		}
	}
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SETFMT, &format) == -1) {
	    fprintf(stderr, "Cannot set %d bits/sample for %s\n",bits, SOUND_DEV);
	    global.echo = 0;
	}

	/* limited sound devices may not support stereo */
	if (stereo
	    && ioctl(global.soundcard_fd, (int)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set stereo mode for %s\n", SOUND_DEV);
	    stereo = 0;
	}
	if (!stereo
            && ioctl(global.soundcard_fd, (int)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set mono mode for %s\n", SOUND_DEV);
	    global.echo = 0;
	}

	/* set the sample rate */
	if (ioctl(global.soundcard_fd, (int)SNDCTL_DSP_SPEED, &garbled_rate) == -1) {
	    fprintf(stderr, "Cannot set rate %g Hz for %s\n",rate, SOUND_DEV);
	    global.echo = 0;
	}
	if ( abs((long)rate - garbled_rate) > rate / 20) {
	    fprintf(stderr, "sound device: next best sample rate is %d\n",garbled_rate);
	}
#endif
    }
  }
#if 0 
  /* if echo is enabled, set speed to 1x */
  if (global.echo)
    global.speed = 1;
#endif
#endif
  return 0;
}
