#!/usr/local/bin/perl
# Guestbook for the World Wide Web
# Created by Matt Wright           Version 2.3.1
# Created on: 4/21/95      	   Last Modified: 10/29/95
# Modified by Stanislav Malyshev   Last Modified: 09/30/97
#             Added: HTML filtering, locking
# Consult the file README for more information and Installation Instructions.
#############################################################################
# Set Variables
$guestbookurl = "http://www.cityline.ru/cgi-bin/last20.cgi";
$guestbookreal = "/usr/local/www/data/vi/books/guestbook.gbk";
$guestlog = "/usr/local/www/data/vi/guestlog.txt";
$cgiurl = "http://www.cityline.ru:$ENV{'SERVER_PORT'}/cgi-bin/gosti_vi.cgi";
$date_command = "/bin/date";
$lockfile="/usr/local/www/data/vi/lock/book"; # This MUST be unique for every book

# Set Your Options:
$mail = '1';              # 1 = Yes; 0 = No
$uselog = '1';          # 1 = Yes; 0 = No
$linkmail = '1';          # 1 = Yes; 0 = No
$separator = '1';         # 1 = <hr>; 0 = <p>
$redirection = '1';       # 1 = Yes; 0 = No
$entry_order = '1';       # 1 = Newest entries added first;
                        # 0 = Newest Entries added last.
$remote_mail = 0;       # 1 = Yes; 0 = No
$allow_html = '1';        # 1 = Yes; 0 = No
$line_breaks = '1';	# 1 = Yes; 0 = No
$cookies = '1';
# allowed tags, Source - O'Reiily's HTML Quick Reference
%allow_tags = (
	       "a",1,
	       "b",1,
	       "big",1,
	       "blink",1,          # or should I trash this one?
	       "i",1,
	       "s",1,
	       "small",1,
	       "strike",1,
	       "sub",1,
	       "sup",1,
	       "tt",1,
	       "u",1,
	       "cite",1,
	       "code",1,
	       "dfn",1,
	       "em",1,
	       "kbd",1,
	       "samp",1,
	       "strong",1,
	       "var",1,
	       "dir",1,
	       "li",1,
	       "dl",1,
	       "dd",1,
	       "dt",1,
	       "menu",1,
	       "ol",1,
	       "ul",1,
	       "address",1,
	       "blockquote",1,
	       "br",1,
	       "center",1,
	       "div",1,
	       "font",1,
	       "h1",1,
	       "h2",1,
	       "h3",1,
	       "h4",1,
	       "h5",1,
	       "h6",1,
	       "hr",1,
	       "listing",1,
	       "nobr",1,                # or not?
	       "p",1,
	       "plaintext",1,
	       "pre",1,
	       "spacer",1,
	       "span",1,
	       "wbr",1,
	       "xmp",1,
	       "table",1,
	       "th",1,
	       "tr",1,
	       "td",1,
	       );
%used_tags=();
# If you answered 1 to $mail or $remote_mail you will need to fill out
# these variables below:
$mailprog = '/usr/sbin/sendmail';
$recipient = 'anton\@cityline.ru';

# Done
#############################################################################

sub en_url {
    local($str)=@_;
    $str =~ s/([^a-zA-Z0-9])/sprintf("=%02X",ord($1))/eg;
    return $str;
}

sub check_tag {
    local($tag,$param)=@_;
    $tag=lc($tag);
    # check against onXXX
    return "" if($param =~ /on[A-Za-z]+\s*=/i);
    # check tag against list of allowed, in lowercase
    if(substr($tag,0,1) eq "/")
    {
	substr($tag,0,1)='';
	if($used_tags{$tag})
	{
	    $used_tags{$tag}--;
	    return "</".uc($tag).">";
	}
	return "";
    }
    return '' unless $allow_tags{$tag};  
    $used_tags{$tag}++;
    $param=" ".$param if $param ne '';
    return "<".uc($tag)."$param>";
}

# Get the Date for Entry
$date = `$date_command +"%A, %B %d, %Y at %T (%Z)"`; chop($date);
$shortdate = `$date_command +"%D %T %Z"`; chop($shortdate);

# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

# Split the name-value pairs
@pairs = split(/&/, $buffer);

foreach $pair (@pairs) {
   ($name, $value) = split(/=/, $pair);

   # Un-Webify plus signs and %-encoding
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<!--(.|\n)*(-->)?//g;  # html comments aren't allowed
   # if no '-->' - strip all record 

   if ($allow_html != 1) {
# || $name ne 'comments') {
      $value =~ s/<([^>]|\n)*>//g;
  } else { # html is allowed - in comments only
      # pass every html tag through a check
      $value =~ s/<([^>\s]*)\s*(([^>]|\n)*)>?/&check_tag($1,$2)/eg;
      # tag isn't closed? strip all text
      # we don't care for lusers who can't close their tags
  }
   $FORM{$name} = $value;
}

# Print the Blank Response Subroutines
&no_comments unless $FORM{'comments'};
&no_name unless $FORM{'realname'};

$ALLOW_CHARS="-a-zA-Z0-9:.@/%_~";

$FORM{'url'} =~ s|[^$ALLOW_CHARS]|_|go;
$FORM{'username'} =~ s|[^$ALLOW_CHARS]|_|go;

sub del_lock {
    unlink("$lockfile");
    exit;
}

sub printGUEST {
    (print GUEST @_) || &printfail("Write failed.\nCall back later");
}

sub printfail {
    print "Content-type: text/html\n\n@_\nPlease write to anton\@cityline.ru\n";
    unlink($lockfile);
    unlink("$guestbookreal.new");
    open (MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";

   print MAIL "Reply-to: $recipient\n";
   print MAIL "To: $recipient\n";
   print MAIL "From: VI guestbook <scriptik\@cityline.ru>\n";
   print MAIL "Subject: Guestbook failure :(\n\n";
   print MAIL "Reason: @_\n";
   print MAIL "Book: $guestbookreal\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "$FORM{'realname'}\n";
   print MAIL "$ENV{'REMOTE_HOST'}\n";
   print MAIL "$ENV{'REMOTE_ADDR'}\n";
   print MAIL "$ENV{'HTTP_REFERER'}\n";
   print MAIL "$ENV{'HTTP_USER_AGENT'}\n";

   if ( $FORM{'username'} ){
      print MAIL " <$FORM{'username'}>";
   }

   print MAIL "\n";

   if ( $FORM{'city'} ){
      print MAIL "$FORM{'city'},";
   }

   if ( $FORM{'state'} ){
      print MAIL " $FORM{'state'}";
   }

   if ( $FORM{'country'} ){
      print MAIL " $FORM{'country'}";
   }

   print MAIL " - $date\n";
   print MAIL "$FORM{'comments'}\n";
   print MAIL "------------------------------------------------------\n";

   close (MAIL);
    exit;
}

$SIG{HUP}=\&del_lock;
$SIG{INT}=\&del_lock;
$SIG{QUIT}=\&del_lock;
$SIG{SEGV}=\&del_lock;
$SIG{PIPE}=\&del_lock;
$SIG{KILL}=\&del_lock;
$SIG{TERM}=\&del_lock;

# check that lock exists and process is alive
while(-l $lockfile && ($lockpid=readlink($lockfile)) && kill(0,$lockpid))
{
    select(undef,undef,undef,rand(5)); #wait for lock    
}
unlink("$lockfile"); # for extra safety
symlink("$$","$lockfile");
# get paranoid
exit if(readlink("$lockfile") != $$); # somebody made link before me

# Begin the Editing of the Guestbook File
&printfail("Empty book.\nSomething fishy is happening") if(-z $guestbookreal);
open (FILE,"$guestbookreal") || die "Can't Open $guestbookreal: $!\n";
@LINES=<FILE>;
close(FILE);
$SIZE=@LINES;
&printfail("Cannot read old book!\n") if(!$SIZE);
# Open Link File to Output
open (GUEST,">$guestbookreal.new") || &printfail("Can't Open $guestbookreal: $!\n");

select GUEST;
$|=1;
select STDOUT;
$tag=time;

for ($i=0;$i<=$SIZE;$i++) {
   $_=$LINES[$i];
   if (/<!--begin-->/) {

      if ($entry_order eq '1') {
         printGUEST "<!--begin-->\n";
      }
      printGUEST "<!--entry:$tag-->\n";
      
      if ($line_breaks == 1) {
         $FORM{'comments'} =~ s/\cM\n/<br>\n/g;
      }


      if ($FORM{'url'}) {
         printGUEST "<table width=500><tr><td bgcolor=#e7e7e7><img src=dot.gif align=left alt=0 width=15 height=15><em> () <a href=\"$FORM{'url'}\">$FORM{'realname'}</a>";
      }
      else {
         printGUEST "<table width=500><tr><td bgcolor=#e7e7e7><img src=dot.gif align=left alt=0 width=15 height=15><em> () $FORM{'realname'}";
      }

      if ( $FORM{'username'} ){
         if ($linkmail eq '1') {
            printGUEST " \&lt;<a href=\"mailto:$FORM{'username'}\">";
            printGUEST "$FORM{'username'}</a>\&gt;";
         }
         else {
            printGUEST " &lt;$FORM{'username'}&gt;";
         }
      }

      printGUEST "<br>\n";

      if ( $FORM{'city'} ){
         printGUEST "$FORM{'city'},";
      }

      if ( $FORM{'state'} ){
         printGUEST " $FORM{'state'}";
      }

      if ( $FORM{'country'} ){
         printGUEST " $FORM{'country'}";
      }


      if ($separator eq '1') {
         printGUEST " - $date<br>\n";
      }
      else {
         printGUEST " - $date<p>\n\n";
      }

      printGUEST "</em><br>$FORM{'comments'}\n";
      # close used tags
      foreach $tag (keys %used_tags) {
	  (printGUEST "</$tag>") while $used_tags{$tag}--;  
      }
      printGUEST "</td></tr></table><p>\n";
      printGUEST "<!--endentry-->\n";

      if ($entry_order eq '0') {
         printGUEST "<!--begin-->\n";
      }

   }
   else {
      printGUEST $_;
   }
}

# Log The Entry

if ($uselog) {
   &log('entry');
}

close (GUEST);
##unlink("$guestbookreal.old") || &printfail("");
rename($guestbookreal,"$guestbookreal.old") || &printfail("Cannot do rename: $!"); 
rename("$guestbookreal.new","$guestbookreal") || &printfail("Cannot do rename2: $!");
chmod(0664,$guestbookreal);
unlink($lockfile);



#########
# Options

# Mail Option
if ($mail eq '1') {
   open (MAIL, "|$mailprog $recipient") || die "Can't open $mailprog!\n";

   print MAIL "Reply-to: $FORM{'username'} ($FORM{'realname'})\n";
   print MAIL "From: $FORM{'username'} ($FORM{'realname'})\n";
   print MAIL "Subject: Entry to Guestbook\n\n";
   print MAIL "You have a new entry in your guestbook:\n\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "$FORM{'realname'}\n";
   print MAIL "$ENV{'REMOTE_HOST'}\n";
   print MAIL "$ENV{'REMOTE_ADDR'}\n";
   print MAIL "$ENV{'HTTP_REFERER'}\n";
   print MAIL "$ENV{'HTTP_USER_AGENT'}\n";

   if ( $FORM{'username'} ){
      print MAIL " <$FORM{'username'}>";
   }

   print MAIL "\n";

   if ( $FORM{'city'} ){
      print MAIL "$FORM{'city'},";
   }

   if ( $FORM{'state'} ){
      print MAIL " $FORM{'state'}";
   }

   if ( $FORM{'country'} ){
      print MAIL " $FORM{'country'}";
   }

   print MAIL " - $date\n";
   print MAIL "$FORM{'comments'}\n";
   print MAIL "------------------------------------------------------\n";

   close (MAIL);
}

if ($remote_mail eq '1' && $FORM{'username'}) {
   open (MAIL, "|$mailprog -t") || die "Can't open $mailprog!\n";

   print MAIL "To: $FORM{'username'}\n";
   print MAIL "From: $recipient\n";
   print MAIL "Subject: Entry to Guestbook at Nashi Seti Archive\n\n";
   print MAIL "Thank you for adding an entry to Nashi Seti guestbook.\n";
   print MAIL "Your entry was registered as follows:\n\n";
   print MAIL "------------------------------------------------------\n";
   print MAIL "$FORM{'realname'}\n";

   if ( $FORM{'username'} ){
      print MAIL " <$FORM{'username'}>";
   }

   print MAIL "\n";

   if ( $FORM{'city'} ){
      print MAIL "$FORM{'city'},";
   }

   if ( $FORM{'state'} ){
      print MAIL " $FORM{'state'}";
   }

   if ( $FORM{'country'} ){
     print MAIL " $FORM{'country'}";
   }

   print MAIL " - $date\n";
   print MAIL "$FORM{'comments'}\n";
   print MAIL "------------------------------------------------------\n\n";
   print MAIL "The entire guestbook thing is experimental, please report bugs\n";
   print MAIL "Yours - Anton Nossik";

   close (MAIL);
}

if($cookies eq '1') {
    print "Set-Cookie: VIG_User=".en_url($FORM{'realname'})."; path=/; expires=Thu, 31-Dec-37 23:59:59 GMT\n" if $FORM{'realname'};
    print "Set-Cookie: VIG_Mail=".en_url($FORM{'username'})."; path=/; expires=Thu, 31-Dec-37 23:59:59 GMT\n" if $FORM{'username'};
    print "Set-Cookie: VIG_URL=".en_url($FORM{'url'})."; path=/\n; expires=Thu, 31-Dec-37 23:59:59 GMT" if $FORM{'url'};
    print "Set-Cookie: VIG_City=".en_url($FORM{'city'})."; path=/; expires=Thu, 31-Dec-37 23:59:59 GMT\n" if $FORM{'city'};
    print "Set-Cookie: VIG_Country=".en_url($FORM{'country'})."; path=/; expires=Thu, 31-Dec-37 23:59:59 GMT\n" if $FORM{'country'};
}
# Print Out Initial Output Location Heading
if ($redirection eq '1') {
   print "Location: $guestbookurl\n\n";
}
else {
   &no_redirection;
}

#######################
# Subroutines

sub no_comments {
   print "Content-type: text/html\n\n";
   print "<html><head><title>A Zapis' Gde?!</title></head>\n";
   print "<body><h2>   </h2>\n";
   print "      - \n";
   print ".         .\n";
   print ",     .<p>\n";
   print "<form method=POST action=\"$cgiurl\">\n";
   print ":<input type=text name=\"realname\" size=30 ";
   print "value=\"$FORM{'realname'}\"><br>\n";
   print "E-Mail: <input type=text name=\"username\"";
   print "value=\"$FORM{'username'}\" size=40><br>\n";
   print ": <input type=text name=\"city\" value=\"$FORM{'city'}\" ";
   print "size=15>, , : <input type=text name=\"state\" ";
   print "value=\"$FORM{'state'}\" size=15> : <input type=text ";
   print "name=\"country\" value=\"$FORM{'country'}\" size=15><p>\n";
   print ":<br>\n";
   print "<textarea name=\"comments\" COLS=60 ROWS=4></textarea><p>\n";
   print "<input type=submit> * <input type=reset></form><hr>\n";
   print ",  <a href=\"$guestbookurl\"> </a>.";
   print "\n</body></html>\n";

   # Log The Error
   if ($uselog eq '1') {
      &log('no_comments');
   }

   exit;
}

sub no_name {
   print "Content-type: text/html\n\n";
   print "<html><head><title>No Name</title></head>\n";
   print "<body><h1>Your Name appears to be blank</h1>\n";
   print "The Name Section in the guestbook fillout form appears to\n";
   print "be blank and therefore your entry to the guestbook was not\n";
   print "added.  Please add your name in the blank below.<p>\n";
   print "<form method=POST action=\"$cgiurl\">\n";
   print "Your Name:<input type=text name=\"realname\" size=30><br>\n";
   print "E-Mail: <input type=text name=\"username\"";
   print " value=\"$FORM{'username'}\" size=40><br>\n";
   print "City: <input type=text name=\"city\" value=\"$FORM{'city'}\" ";
   print "size=15>, State: <input type=text name=\"state\" ";
   print "value=\"$FORM{'state'}\" size=2> Country: <input type=text ";
   print "value=USA name=\"country\" value=\"$FORM{'country'}\" ";
   print "size=15><p>\n";
   print "Comments have been retained.<p>\n";
   print "<input type=hidden name=\"comments\" ";
   print "value=\"$FORM{'comments'}\">\n";
   print "<input type=submit> * <input type=reset><hr>\n";
   print "Return to the <a href=\"$guestbookurl\">Guestbook</a>.";
   print "\n</body></html>\n";

   # Log The Error
   if ($uselog eq '1') {
      &log('no_name');
   }

   exit;
}

# Log the Entry or Error
sub log {
   $log_type = $_[0];
   open (LOG, ">>$guestlog");
   if ($log_type eq 'entry') {
      print LOG "$guestbookreal: $ENV{'REMOTE_HOST'}|$ENV{HTTP_VIA}|$ENV{HTTP_X_FORWARDED_FOR} - [$shortdate]<br>\n";
   }
   elsif ($log_type eq 'no_name') {
      print LOG "$guestbookreal: $ENV{'REMOTE_HOST'} - [$shortdate] - ERR: No Name<br>\n";
   }
   elsif ($log_type eq 'no_comments') {
      print LOG "$guestbookreal: $ENV{'REMOTE_HOST'} - [$shortdate] - ERR: No ";
      print LOG "Comments<br>\n";
   }
   close(LOG);
}

# Redirection Option
sub no_redirection {

   # Print Beginning of HTML
   print "Content-Type: text/html\n\n";
   print "<html><head><title>Thank You</title></head>\n";
   print "<body><h1>Thank You For Signing The Guestbook</h1>\n";

   # Print Response
   print "Thank you for filling in the guestbook.  Your entry has\n";
   print "been added to the guestbook.<hr>\n";
   print "Here is what you submitted:<p>\n";
   print "<b>$FORM{'comments'}</b><br>\n";

   if ($FORM{'url'}) {
      print "<a href=\"$FORM{'url'}\">$FORM{'realname'}</a>";
   }
   else {
      print "$FORM{'realname'}";
   }

   if ( $FORM{'username'} ){
      if ($linkmail eq '1') {
         print " &lt;<a href=\"mailto:$FORM{'username'}\">";
         print "$FORM{'username'}</a>&gt;";
      }
      else {
         print " &lt;$FORM{'username'}&gt;";
      }
   }

   print "<br>\n";

   if ( $FORM{'city'} ){
      print "$FORM{'city'},";
   }

   if ( $FORM{'state'} ){
      print " $FORM{'state'}";
   }

   if ( $FORM{'country'} ){
      print " $FORM{'country'}";
   }

   print " - $date<p>\n";

   # Print End of HTML
   print "<hr>\n";
   print "<a href=\"$guestbookurl\">Back to the Guestbook</a>\n";         print "- You may need to reload it when you get there to see your\n";
   print "entry.\n";
   print "</body></html>\n";

   exit;
}

